/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.intercept.filter;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import com.kantegasso.servlet.http.StatusPreservableHeaderAwareResponse;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction3;
import io.vavr.control.Option;
import io.vavr.control.Try;
import io.vavr.control.Validation;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.ManualLoginEvent;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.diagnostics.FailureListener;
import org.kantega.atlaskerb.hostapp.AuthContextPreservableHttpServletRequest;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.identityproviders.IdpConfiguration;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.intercept.model.Intercept;
import org.kantega.atlaskerb.intercept.model.InterceptExitCondition;
import org.kantega.atlaskerb.intercept.model.InterceptResult;
import org.kantega.atlaskerb.intercept.strategy.InterceptAuthStrategy;
import org.kantega.atlaskerb.intercept.strategy.KerberosFilterCoreStrategy;
import org.kantega.atlaskerb.kerberos.PrincipalEntry;
import org.kantega.atlaskerb.restapi.access.RestrictAPIEndpoint;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.restapi.access.UnblockAPIEndpoint;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.saml.SsoScriptLoginHookUrlReadingCondition;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.InternetAddressUtils;
import org.kantega.atlaskerb.utils.KssoStringUtils;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestInterceptor.class);
    private static final Logger manualLoginLog = LoggerFactory.getLogger(ManualLoginEvent.class);
    private final KerbConfManager kerbConfManager;
    private final AuditLogFacade auditLogFacade;
    private final IdpConfManager idpConfManager;
    private final HostApp hostApp;
    private final SsoScriptLoginHookUrlReadingCondition loginScriptCondition;
    private final ApiTokenService apiTokenService;
    private final TokenEndpointService tokenEndpointService;
    private final UserLookupService userLookupService;
    private final KerberosFilterCoreStrategy kerberosFilterCore;

    public RequestInterceptor(HttpContext httpContext, FailureListener failureListener, AuditLogFacade auditLogFacade, RequireAdminServletDependencyBucket bucket, SsoScriptLoginHookUrlReadingCondition ssoScriptLoginHookUrlReadingCondition) {
        this.kerbConfManager = bucket.getKerbConfManager();
        this.apiTokenService = bucket.getApiTokenService();
        this.tokenEndpointService = bucket.getTokenEndpointService();
        this.auditLogFacade = auditLogFacade;
        this.userLookupService = bucket.getUserLookupService();
        this.hostApp = bucket.getHostApp();
        this.idpConfManager = bucket.getIdpConfManager();
        this.loginScriptCondition = ssoScriptLoginHookUrlReadingCondition;
        this.kerberosFilterCore = new KerberosFilterCoreStrategy(failureListener, auditLogFacade, bucket);
    }

    private @NonNull InterceptAuthStrategy selectInterceptStrategy(Intercept intercept) {
        switch (intercept) {
            case OTHER_AUTH_TOKEN: {
                return this.otherAuthTokens();
            }
            case REST_API_ACCESS: {
                return this.restrictRestApiToTokens();
            }
            case LICENSE: {
                return this.checkLicense();
            }
            case HANDLE_TRADITIONAL_LOGIN: {
                return this.handleTraditionalLogin();
            }
            case ANONYMOUS_BROWSING: {
                return this.authenticatedAnonymousBrowsing();
            }
            case API_TOKEN: {
                return this.authenticateWithApiToken();
            }
            case USERNAME_FROM_HEADER: {
                return this.usernameFromHeader();
            }
            case ALREADY_LOGGED_IN: {
                return this.alreadyLoggedIn();
            }
            case KERBEROS: {
                return this.kerberosFilterCore;
            }
            case FEDERATED_SSO: {
                return this.federatedSso();
            }
            case PASS_DOWN_FILTER_CHAIN: {
                return (req, resp) -> InterceptResult.passDownFilterChain();
            }
        }
        return (req, resp) -> InterceptResult.continueNext();
    }

    private InterceptAuthStrategy otherAuthTokens() {
        return (request, response) -> {
            if (this.hostApp.isAuthTokenRequest(request)) {
                log.debug("Not processing request because it already has auth tokens. Passing down filter chain...");
                return InterceptResult.passDownFilterChain();
            }
            return InterceptResult.continueNext();
        };
    }

    private InterceptAuthStrategy usernameFromHeader() {
        return (request, response) -> {
            String usernameFromHeader = this.getUsernameFromHeader(request);
            if (usernameFromHeader != null) {
                try {
                    PrincipalEntry principalEntry = this.userLookupService.resolveUserInDirectories(usernameFromHeader, true);
                    if (principalEntry.getPrincipal().isPresent()) {
                        Principal principal = principalEntry.getPrincipal().get();
                        return InterceptResult.of("Successful username from header").setType(InterceptExitCondition.LOGIN_SUCCESS).setAuthMethod(AuthMethod.USERNAME_FROM_HEADER).setPrincipal(principal).build();
                    }
                    this.auditLogFacade.loginFailed(null, AuthMethod.USERNAME_FROM_HEADER, "Could not find username " + usernameFromHeader + " in any directory. Trying other mechanisms to log in user.");
                    return InterceptResult.continueNext("Username from header user not found. Try next auth method..");
                }
                catch (Exception e) {
                    this.auditLogFacade.loginFailed(null, "HeaderUsername", "Failed looking up " + usernameFromHeader + ". Trying other mechanisms to log in user.");
                    return InterceptResult.continueNext("Failed username from header. Try next auth method..");
                }
            }
            return InterceptResult.continueNext();
        };
    }

    private boolean shouldBlockRequest(HttpServletRequestFacade req) throws UnsupportedEncodingException {
        String sanitizedInternalPath = HttpUrlUtils.sanitizeUrlForTrailingSlashes((String)HttpUrlUtils.getInternalPath((HttpServletRequestFacade)req));
        List<RestrictAPIEndpoint> restrictAPIEndpoints = this.tokenEndpointService.findAllRestApiTokenEndpoints();
        List<UnblockAPIEndpoint> unblockAPIEndpoints = this.tokenEndpointService.findAllUnblockedRestApiTokenEndpoints();
        boolean urlIsApiTokenUnblocked = false;
        String remoteIp = this.kerbConfManager.getRemoteIpAddress(req);
        for (UnblockAPIEndpoint restEndpoint : unblockAPIEndpoints) {
            if (!StringUtils.isBlank((CharSequence)restEndpoint.getClientIP()) && !StringUtils.equals((CharSequence)restEndpoint.getClientIP(), (CharSequence)remoteIp) || sanitizedInternalPath == null || !sanitizedInternalPath.startsWith(HttpUrlUtils.urlDecode((String)restEndpoint.getInternalPathRest()))) continue;
            urlIsApiTokenUnblocked = true;
            break;
        }
        boolean urlIsApiTokenRestricted = restrictAPIEndpoints.stream().anyMatch(endpoint -> (Boolean)Try.of((CheckedFunction0 & Serializable)() -> endpoint).mapTry(RestrictAPIEndpoint::getInternalPathRest).mapTry(HttpUrlUtils::urlDecode).mapTry(sanitizedInternalPath::startsWith).getOrElse((Object)false));
        boolean isExternalCall = !this.hostApp.isRequestFromHostApp(req) && !this.hostApp.isRestPathInternalAtlassianFunctionality(req) && !this.hostApp.isJiraCrowdRequest(req);
        boolean requestHasApiToken = this.apiTokenService.requestHasApiToken(req);
        boolean isRestApiCompleteLockdown = this.kerbConfManager.isRestApiCompleteLockdown();
        boolean clientAllowedBasicAuth = (Boolean)Try.of((CheckedFunction0 & Serializable)() -> req.getAttribute("ksso.allowed.basic.auth")).mapTry(String.class::cast).map(attr -> StringUtils.equals((CharSequence)attr, (CharSequence)"true")).getOrElse((Object)false);
        boolean shouldBlockRequest = urlIsApiTokenRestricted && !urlIsApiTokenUnblocked && !requestHasApiToken && (isExternalCall || HttpUrlUtils.requestHasBasicAuthHeader((HttpServletRequestFacade)req) && !clientAllowedBasicAuth || isRestApiCompleteLockdown);
        log.debug("KSSO Rest API Access. restricted API endpoints: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List)io.vavr.collection.List.ofAll(restrictAPIEndpoints).map(RestrictAPIEndpoint::getCompleteUrl), (KssoStringUtils.StringLiteral)KssoStringUtils.StringLiteral.COMMA_AND_SPACE) + " unblocked API endpoints: " + ListParseUtils.listToSeparatedString((io.vavr.collection.List)io.vavr.collection.List.ofAll(unblockAPIEndpoints).map(UnblockAPIEndpoint::getCompleteUrl), (KssoStringUtils.StringLiteral)KssoStringUtils.StringLiteral.COMMA_AND_SPACE));
        log.debug("Requested URL: " + req.getRequestURL().toString());
        log.debug("KSSO Rest API Access. isRestApiRestrictedToApiTokens => true");
        log.debug("KSSO Rest API Access. hostApp.isRequestFromHostApp(req): " + this.hostApp.isRequestFromHostApp(req));
        log.debug("KSSO Rest API Access. hostApp.isRestPathInternalAtlassianFunctionality(req): " + this.hostApp.isRestPathInternalAtlassianFunctionality(req));
        log.debug("KSSO Rest API Access. hostApp.isAuthTokenRequest(req): " + this.hostApp.isAuthTokenRequest(req));
        log.debug("KSSO Rest API Access. hostApp.isJiraCrowdRequest(req): " + this.hostApp.isJiraCrowdRequest(req));
        log.debug("KSSO REST API Access. clientAllowedBasicAuth: " + clientAllowedBasicAuth);
        if (isRestApiCompleteLockdown && HttpUrlUtils.requestHasBasicAuthHeader((HttpServletRequestFacade)req) && clientAllowedBasicAuth) {
            log.debug("KSSO REST API Access. Client allowed basic auth will be blocked because complete lockdown is selected");
        } else if (isExternalCall && HttpUrlUtils.requestHasBasicAuthHeader((HttpServletRequestFacade)req) && clientAllowedBasicAuth) {
            log.debug("KSSO REST API Access. Client allowed basic auth will be let through REST API access");
        }
        log.debug("KSSO REST API Access. urlIsApiTokenUnblocked: ", (Object)urlIsApiTokenUnblocked);
        log.debug("KSSO Rest API Access. urlIsApiTokenRestricted: " + urlIsApiTokenRestricted);
        log.debug("KSSO REST API Access. isExternalCall: " + isExternalCall);
        log.debug("KSSO REST API Access. requestHasApiToken: " + requestHasApiToken);
        log.debug("KSSO REST API Access. isRestApiCompleteLockdown: " + isRestApiCompleteLockdown);
        log.debug("KSSO REST API Access. shouldBlockRequest: " + shouldBlockRequest);
        return shouldBlockRequest;
    }

    private InterceptAuthStrategy authenticateWithApiToken() {
        return (request, response) -> {
            if (this.hostApp.shouldTryApiTokenAuthentication(request) && this.apiTokenService.requestHasApiToken(request)) {
                log.debug("Attempting to authenticate KSSO API Token");
                Validation<String, UserProfile> validation = this.apiTokenService.validateApiToken(request);
                if (validation.isValid()) {
                    UserProfile userProfile = (UserProfile)validation.get();
                    String username = userProfile.getUsername();
                    log.debug("KSSO API Token for user " + username + " is valid. Looking up user.");
                    Option principalEntry = Option.of((Object)this.userLookupService.resolveUser(username)).peek(_principal -> log.debug("PrincipalEntry.getPrincipal is present?: " + _principal.getPrincipal().isPresent())).onEmpty(() -> log.debug("PrincipalEntry empty for username " + username));
                    if (principalEntry.isDefined()) {
                        if (((PrincipalEntry)principalEntry.get()).getUserState() == PrincipalEntry.UserState.FOUND) {
                            Optional<Principal> maybePrincipal = ((PrincipalEntry)principalEntry.get()).getPrincipal();
                            if (maybePrincipal.isPresent()) {
                                Principal principal = maybePrincipal.get();
                                log.debug("Principal: " + principal.getName());
                                log.debug("Successfully logged in " + username + ". ");
                                request.setAttribute("ALREADY_FILTERED_API TOKENS", (Object)Boolean.TRUE);
                                Try<Integer> maybeFailedLoginAttempts = this.hostApp.getFailedLoginAttempts(principal);
                                return InterceptResult.of("Valid Kantega SSO API token").setType(InterceptExitCondition.LOGIN_SUCCESS).setAuthMethod(AuthMethod.API_TOKEN).setUsername(username).setPrincipal(principal).setFailedLoginAttempts((Integer)maybeFailedLoginAttempts.getOrNull()).setCustomFilterCallback((CheckedFunction3<HttpServletRequestFacade, HttpServletResponseFacade, FilterChainFacade, Void>)(CheckedFunction3 & Serializable)(req, resp, chain) -> {
                                    chain.doFilterKsso((HttpServletRequestFacade)AuthContextPreservableHttpServletRequest.of(req), StatusPreservableHeaderAwareResponse.of((HttpServletResponse)resp));
                                    return null;
                                }).build();
                            }
                            log.debug("Principal for user " + username + " not found. Could not complete API token authentication");
                            return InterceptResult.of("User principal not found during KSSO API Token auth").setType(InterceptExitCondition.LOGIN_FAILED).setAuthMethod(AuthMethod.API_TOKEN).setUsername(username).setHttpStatus(Response.Status.UNAUTHORIZED).build();
                        }
                        if (((PrincipalEntry)principalEntry.get()).getUserState() == PrincipalEntry.UserState.INACTIVE) {
                            log.debug("User " + username + " inactive. Could not complete API token authentication");
                            this.auditLogFacade.loginFailed(username, "KANTEGA SSO API TOKEN", "User inactive");
                            return InterceptResult.of("User inactive").setType(InterceptExitCondition.LOGIN_FAILED).setAuthMethod(AuthMethod.API_TOKEN).setUsername(username).setHttpStatus(Response.Status.UNAUTHORIZED).build();
                        }
                        log.debug("Userstate for " + username + " not found. Could not complete API token authentication");
                        return InterceptResult.of("Userstate='not found' during KSSO API Token auth.").setType(InterceptExitCondition.LOGIN_FAILED).setUsername(username).setAuthMethod(AuthMethod.API_TOKEN).setHttpStatus(Response.Status.UNAUTHORIZED).build();
                    }
                } else {
                    if (this.apiTokenService.requestHasApiToken(request) && validation.isInvalid()) {
                        log.debug("Invalid KSSO API Token");
                        return InterceptResult.of("KSSO API Token not valid").setAuthMethod(AuthMethod.API_TOKEN).setType(InterceptExitCondition.LOGIN_FAILED).setHttpStatus(Response.Status.FORBIDDEN).build();
                    }
                    log.debug("KSSO API token not recognized. Passing down filter chain");
                    return InterceptResult.of("KSSO API token not recognized. Passing down filter chain").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
                }
            }
            return InterceptResult.continueNext();
        };
    }

    private InterceptAuthStrategy restrictRestApiToTokens() {
        return (request, response) -> {
            boolean shouldBlockRequest;
            if (this.hostApp.isRestApi(HttpUrlUtils.getInternalPath((HttpServletRequestFacade)request)) && this.kerbConfManager.isRestApiRestrictedToApiTokens() && (shouldBlockRequest = this.shouldBlockRequest(request))) {
                log.debug("KSSO REST API Access restricted to API tokens only. Blocked requested URL: " + request.getRequestURL().toString());
                String blockedMessage = (String)Option.of((Object)(this.kerbConfManager.getLockedRestApiErrorPageMessage() + " Requested URL: " + request.getRequestURI())).getOrElse((Object)this.kerbConfManager.getDefaultLockedRestApiErrorPageMessage(request.getRequestURI()));
                String username = (String)HttpUrlUtils.credentialsWithBasicAuthSingleHeader((HttpServletRequestFacade)request).map(usernameAndPassword -> (String)usernameAndPassword._1()).getOrElse((Object)"anonymous");
                log.debug("KSSO REST API Access. Blocked login for username: " + username);
                log.debug(blockedMessage);
                return InterceptResult.of(blockedMessage).setAuthMethod(AuthMethod.REST_API_AUTH).setType(InterceptExitCondition.LOGIN_FAILED).setHttpStatus(Response.Status.FORBIDDEN).setUsername(username).build();
            }
            return InterceptResult.continueNext();
        };
    }

    private InterceptAuthStrategy alreadyLoggedIn() {
        return (request, response) -> {
            if (this.hostApp.isLoggedIn(request)) {
                log.debug("isLoggedIn(req) -> doFilter");
                if (this.hostApp.shouldTryApiTokenAuthentication(request) && this.apiTokenService.requestHasApiToken(request)) {
                    log.debug("Request has KSSO API token. Avoid attempting normal login");
                    return InterceptResult.of("Already logged in. Avoid API token auth").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).setCustomFilterCallback((CheckedFunction3<HttpServletRequestFacade, HttpServletResponseFacade, FilterChainFacade, Void>)(CheckedFunction3 & Serializable)(req, res, chain) -> {
                        chain.doFilterKsso((HttpServletRequestFacade)AuthContextPreservableHttpServletRequest.of(req), res);
                        return null;
                    }).build();
                }
                return InterceptResult.of("Already logged in. Pass down filter chain").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
            }
            return InterceptResult.continueNext();
        };
    }

    private InterceptAuthStrategy authenticatedAnonymousBrowsing() {
        return (request, response) -> {
            if (this.idpConfManager.isAuthenticatedAnonymousBrowsingSessionActive(request)) {
                HttpSession session = request.getSession(false);
                String sessionUser = (String)Option.of((Object)session.getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_USER")).map(String.class::cast).getOrElse((Object)"<anonymous>");
                String idpId = (String)Option.of((Object)session.getAttribute("KSSO_AUTH_ANONYMOUS_BROWSING_SESSION_IDP_ID")).map(String.class::cast).getOrElse((Object)"");
                IdpConfiguration configuration = this.idpConfManager.getIdentityProviderById(idpId);
                if (this.hostApp.isMainLoginPage(request) && StringUtils.contains((CharSequence)request.getQueryString(), (CharSequence)"clear_anonymous_session")) {
                    log.debug("Invalidating session of SSO-Verified Anonymous Access session for user: {} ", (Object)sessionUser);
                    session.invalidate();
                    return InterceptResult.continueNext();
                }
                if (configuration.isSsoProtectedAnonymousBrowsingEnabled()) {
                    log.debug("SSO-Verified Anonymous Access session is enabled and user: {} has an active session. Aborting login.", (Object)sessionUser);
                    return InterceptResult.of("Anonymous browsing session enabled").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
                }
                return InterceptResult.continueNext();
            }
            return InterceptResult.continueNext();
        };
    }

    private InterceptAuthStrategy federatedSso() {
        return (request, response) -> {
            if (this.loginScriptCondition.shouldDoFederatedSSO(request)) {
                return InterceptResult.of("Dispatch to login with federated sso").setType(InterceptExitCondition.DISPATCH_TO_LOGIN).build();
            }
            return InterceptResult.continueNext();
        };
    }

    public @NonNull InterceptResult intercept(HttpServletRequestFacade request, HttpServletResponseFacade response, List<Intercept> interceptOrder) throws IOException {
        try {
            for (Intercept key : interceptOrder) {
                log.debug("Checking intercept strategy: " + String.valueOf((Object)key) + " on URI " + request.getRequestURI());
                InterceptResult result = this.selectInterceptStrategy(key).apply(request, response);
                log.debug("Result from intercept {}: {} on URI {}", new Object[]{key, result, request.getRequestURI()});
                if (result.getType() == InterceptExitCondition.NEXT_INTERCEPT) continue;
                log.debug("Exit condition from filter. " + String.valueOf((Object)result.getType()));
                return result;
            }
        }
        catch (Exception e) {
            log.warn("Something went wrong while processing the request: ", (Throwable)e);
        }
        return InterceptResult.passDownFilterChain();
    }

    private InterceptAuthStrategy checkLicense() {
        return (request, response) -> {
            PluginLicense pluginLicense = null;
            try {
                if (this.kerbConfManager.getLicenseManager().getLicense().isDefined()) {
                    pluginLicense = (PluginLicense)this.kerbConfManager.getLicenseManager().getLicense().get();
                }
                if (pluginLicense == null) {
                    String msg = "No plugin license for Kantega SSO Enterprise";
                    log.warn("No plugin license for Kantega SSO Enterprise");
                    return InterceptResult.of("No plugin license for Kantega SSO Enterprise").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
                }
                if (!pluginLicense.isValid()) {
                    String msg = "License is not valid";
                    log.info("License is not valid");
                    return InterceptResult.of("License is not valid").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
                }
                return InterceptResult.continueNext();
            }
            catch (Exception e) {
                String msg = "Exception while obtaining license for check";
                log.error("Exception while obtaining license for check", (Throwable)e);
                return InterceptResult.of("Exception while obtaining license for check").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
            }
        };
    }

    private InterceptAuthStrategy handleTraditionalLogin() {
        return (request, response) -> {
            if (this.hostApp.isLoginRequest(request)) {
                String username = this.hostApp.getLoginRequestUsername(request);
                this.addGroupsToUser(request, username);
                if (this.kerbConfManager.isManualLoginLogEnabled()) {
                    manualLoginLog.warn("Username/password login attempt recorded: ip: " + this.kerbConfManager.getRemoteIpAddress(request) + ", username: " + username + ", userAgent: " + request.getHeader("User-Agent"));
                }
                this.hostApp.hasUsedTraditionalLogin(request, response);
                log.debug("isLoginRequest(req) -> doFilter");
                return new InterceptResult.Builder("Register Traditional Login. Passing down filter chain").setType(InterceptExitCondition.PASS_DOWN_FILTER_CHAIN).build();
            }
            this.hostApp.notLoginRequest(request, response);
            return new InterceptResult.Builder("Not login request. Continue checking the next intercept").setType(InterceptExitCondition.NEXT_INTERCEPT).build();
        };
    }

    private void addGroupsToUser(HttpServletRequestFacade request, String username) {
        try {
            User user;
            JSONArray groupAddRules = this.kerbConfManager.getPasswordLoginGroupAddMapping();
            if (!groupAddRules.isEmpty() && (user = this.hostApp.getCrowdService().authenticate(username, this.hostApp.getLoginRequestPassword(request))) != null) {
                Optional<Principal> principal = this.userLookupService.resolveUserInDirectories(username, false).getPrincipal();
                for (int i = 0; i < groupAddRules.length(); ++i) {
                    JSONObject groupRule = groupAddRules.getJSONObject(i);
                    String requiredGroup = groupRule.getString("requiredGroup");
                    if (!principal.isPresent() || !StringUtils.isBlank((CharSequence)requiredGroup) && !this.hostApp.isUserInGroup(username, requiredGroup)) continue;
                    this.hostApp.addUserToGroup(principal.get(), groupRule.getString("addedGroup"));
                }
            }
        }
        catch (FailedAuthenticationException failedAuthenticationException) {
            // empty catch block
        }
    }

    public String getUsernameFromHeader(HttpServletRequestFacade req) {
        String remoteAddr = req.getRemoteAddr();
        if (this.kerbConfManager.isHeaderauthUseXForwardedFor()) {
            remoteAddr = HttpUrlUtils.getRemoteIpXForwardedFor((HttpServletRequestFacade)req);
        }
        String headerAttribute = this.kerbConfManager.getHeaderUsernameAttribute();
        String qs = req.getQueryString();
        boolean skipHeaderAuth = StringUtils.contains((CharSequence)qs, (CharSequence)"noheadersso") || StringUtils.contains((CharSequence)qs, (CharSequence)"noautosso") || StringUtils.contains((CharSequence)qs, (CharSequence)"noheaderauth") || StringUtils.contains((CharSequence)qs, (CharSequence)"noredirect") || StringUtils.contains((CharSequence)qs, (CharSequence)"nosso");
        boolean headerUsernameIpUnblocked = InternetAddressUtils.isAddressPermissionMatch((String)remoteAddr, (String[])this.kerbConfManager.getHeaderUsernameIpUnblockedList());
        if (headerUsernameIpUnblocked && headerAttribute != null && !skipHeaderAuth) {
            return req.getHeader(headerAttribute);
        }
        return null;
    }

    private boolean isForwarded(HttpServletRequestFacade req) {
        return req.getAttribute("javax.servlet.forward.request_uri") != null;
    }
}

