/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.intercept.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.kantegasso.servlet.FilterChainFacade;
import com.kantegasso.servlet.FilterConfigFacade;
import com.kantegasso.servlet.FilterFacade;
import com.kantegasso.servlet.http.CachedBodyHttpServletRequest;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.AvoidNameEmailChange;
import org.kantega.atlaskerb.IpRestrictionFilter;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.diagnostics.AuditLogFacade;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.intercept.model.AuthMethod;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.userlookup.UserLookupService;
import org.kantega.atlaskerb.utils.AuthorizationUtil;
import org.kantega.atlaskerb.utils.CookieUtil;
import org.kantega.atlaskerb.utils.HttpUrlUtils;
import org.kantega.atlaskerb.utils.TraditionalLoginUtils;
import org.kantega.atlaskerb.utils.UserManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class AtlasKerberosPreFilter
extends FilterFacade {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final KerbConfManager kerbConfManager;
    private final ApiTokenService apiTokenService;
    private String[] products;
    private final UserLookupService userLookupService;
    private final HostApp hostApp;
    private final AuditLogFacade auditLogFacade;
    private final UserManager userManager;
    private final ScimConfManager scimConfManager;
    private final ConnectorConfManager connectorConfManager;
    public static final String ALLOW_BASIC_AUTH_ATTR = "ksso.allowed.basic.auth";

    @Inject
    public AtlasKerberosPreFilter(KerbConfManager kerbConfManager, ApiTokenService apiTokenService, HostAppFactory hostAppFactory, UserLookupService userLookupService, AuditLogFacade auditLogFacade, RequireAdminServletDependencyBucket bucket) {
        this.kerbConfManager = kerbConfManager;
        this.apiTokenService = apiTokenService;
        this.hostApp = hostAppFactory.getInstance();
        this.userLookupService = userLookupService;
        this.auditLogFacade = auditLogFacade;
        this.userManager = bucket.getUserManager();
        this.scimConfManager = bucket.getScimConfManager();
        this.connectorConfManager = bucket.getConnectorConfManager();
    }

    public void doFilterKsso(HttpServletRequestFacade filterRequest, HttpServletResponseFacade filterResponse, FilterChainFacade chain) {
        try {
            HttpServletRequestFacade maybeCachedRequest = HttpServletRequestFacade.of((HttpServletRequest)filterRequest.getHttpServletRequest());
            if (this.hostApp.shouldCacheBodyRequest(maybeCachedRequest)) {
                maybeCachedRequest = new CachedBodyHttpServletRequest(filterRequest);
            }
            HttpServletResponseFacade res = HttpServletResponseFacade.of((HttpServletResponse)filterResponse);
            String remoteIpAddress = this.kerbConfManager.getRemoteIpAddress(maybeCachedRequest);
            String username = (String)HttpUrlUtils.extractUsernameFromBasicAuthHeader((HttpServletRequestFacade)maybeCachedRequest).getOrElse((Object)"anonymous");
            if (!this.isProductMatch()) {
                if (this.hostApp.shouldCacheBodyRequest(maybeCachedRequest)) {
                    chain.doFilterKssoKeepWrapped(HttpServletRequestFacade.of((HttpServletRequest)maybeCachedRequest), filterResponse);
                } else {
                    chain.doFilterKsso(maybeCachedRequest, filterResponse);
                }
                return;
            }
            if (this.hostApp.isScimRequest(maybeCachedRequest)) {
                chain.doFilterKsso(this.wrapScimAuthHeader(maybeCachedRequest), res);
                this.log.trace("Request to SCIM server. Avoid normal login");
                return;
            }
            this.log.trace("isBasicAuthPreventedByFileExisting -> {}", (Object)this.kerbConfManager.isBasicAuthPreventedByFileExisting());
            this.log.trace("getBasicAuthPermissionType -> {}", (Object)this.kerbConfManager.getBasicAuthPermissionType());
            IpRestrictionFilter basicAuthIpRestrictionFilter = this.kerbConfManager.getIpRestrictionConfig().getBasicAuthFilter();
            if (AuthorizationUtil.isBasicAuth((HttpServletRequestFacade)maybeCachedRequest) && !this.apiTokenService.requestHasApiToken(maybeCachedRequest) && !this.hostApp.isJiraCrowdRequest(maybeCachedRequest)) {
                this.log.trace("isRemoteAddressEnabledForBasicAuth -> {}", (Object)basicAuthIpRestrictionFilter.isRemoteAddressEnabled(remoteIpAddress));
                this.log.trace("requestHasApiToken -> {}", (Object)this.apiTokenService.requestHasApiToken(maybeCachedRequest));
                this.log.trace("isJiraCrowdRequest -> {}", (Object)this.hostApp.isJiraCrowdRequest(maybeCachedRequest));
                if (!this.isUserAllowedToUseBasicAuthLogin(chain, maybeCachedRequest, res, username, basicAuthIpRestrictionFilter, remoteIpAddress)) {
                    res.sendError(403, "HTTP Basic Auth has been disabled by the Administrator");
                    return;
                }
                maybeCachedRequest.getSession().setAttribute(ALLOW_BASIC_AUTH_ATTR, (Object)"true");
            }
            this.log.trace("isTraditionalLoginPrevented() -> {}", (Object)this.kerbConfManager.isTraditionalLoginPrevented());
            if ((this.kerbConfManager.isTraditionalLoginPrevented() || this.kerbConfManager.isTraditionalLoginJsmPrevented()) && this.hostApp.isPasswordLoginRequest(maybeCachedRequest)) {
                this.preventTraditionalLoginIfUserIsNotAllowedToUseTraditionalLogin(chain, maybeCachedRequest, res);
            } else {
                this.hostApp.storeLdapPassword(maybeCachedRequest);
                if (this.avoidEditUserInCloudDirectory(chain, maybeCachedRequest, res)) {
                    return;
                }
                if (this.hostApp.shouldCacheBodyRequest(maybeCachedRequest)) {
                    chain.doFilterKssoKeepWrapped(HttpServletRequestFacade.of((HttpServletRequest)maybeCachedRequest), filterResponse);
                } else {
                    chain.doFilterKsso(maybeCachedRequest, filterResponse);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkBasicAuthUserGroupDirectoryAccess(HttpServletResponseFacade filterResponse, FilterChainFacade chain, HttpServletRequestFacade cachedRequest) throws IOException {
        String basicAuthUsername = (String)HttpUrlUtils.getUsernameFromBasicAuthHeader((HttpServletRequestFacade)cachedRequest).getOrElse((Object)"anonymous");
        boolean isUserHasAccess = this.userLookupService.hasUserAccess(basicAuthUsername);
        this.log.trace("userLookupService.isUserHasAccess -> " + isUserHasAccess);
        ArrayList<Directory> dirsAllowing = new ArrayList();
        this.log.trace("Searching for user directories for user access in traditional login");
        try {
            dirsAllowing = this.userLookupService.getCachedDirectoriesAllowingBasicAuth();
        }
        catch (RuntimeException e) {
            this.log.warn("Not able to search for directories checking Basic Auth exceptions: " + e.getMessage());
        }
        Set<String> allowGroups = this.kerbConfManager.getAllowBasicAuthGroups();
        Set<String> disAllowGroups = this.kerbConfManager.getDisallowBasicAuthGroups();
        boolean userInAllowedDirectoryOrGroup = this.userLookupService.isUserInAllowedDirectoryOrGroup(dirsAllowing, this.hostApp, allowGroups, disAllowGroups, basicAuthUsername, AuthMethod.BASIC_AUTH);
        if (userInAllowedDirectoryOrGroup) {
            this.log.trace("User directory or group exception to Basic Auth restriction.");
            return true;
        }
        return false;
    }

    boolean isUserAllowedToUseBasicAuthLogin(FilterChainFacade chain, HttpServletRequestFacade cachedRequest, HttpServletResponseFacade res, String username, IpRestrictionFilter basicAuthIpRestrictionFilter, String remoteIpAddress) throws IOException {
        switch (this.kerbConfManager.getBasicAuthPermissionType()) {
            case ENABLE_ALL_USERS: {
                return true;
            }
            case DISABLE_ALL_USERS: {
                this.auditLogFacade.loginFailed(username, "Basic Auth", "Basic Auth disabled for all users ");
                this.log.trace("Blocking BasicAuth authentication for all users");
                break;
            }
            case IP_ADDRESS_GROUP_DIRECTORY: {
                if (!basicAuthIpRestrictionFilter.isRemoteAddressEnabled(remoteIpAddress)) {
                    this.auditLogFacade.loginFailed(username, "Basic Auth", "Basic Auth disabled for user with IP " + remoteIpAddress);
                    this.log.trace("Blocking BasicAuth authentication request for IP " + remoteIpAddress);
                    break;
                }
                if (!this.checkBasicAuthUserGroupDirectoryAccess(res, chain, cachedRequest)) break;
                return true;
            }
            case GROUP_DIRECTORY: {
                if (!this.checkBasicAuthUserGroupDirectoryAccess(res, chain, cachedRequest)) break;
                return true;
            }
            case IP_ADDRESS: {
                if (!basicAuthIpRestrictionFilter.isRemoteAddressEnabled(remoteIpAddress)) {
                    this.auditLogFacade.loginFailed(username, "Basic Auth", "Basic Auth disabled for user with IP " + remoteIpAddress);
                    this.log.trace("Blocking BasicAuth authentication request for IP " + remoteIpAddress);
                    break;
                }
                return true;
            }
        }
        return false;
    }

    private void preventTraditionalLoginIfUserIsNotAllowedToUseTraditionalLogin(FilterChainFacade chain, HttpServletRequestFacade cachedRequest, HttpServletResponseFacade res) throws IOException {
        String username = this.hostApp.getLoginRequestUsername(cachedRequest);
        boolean isUserHasAccess = this.userLookupService.hasUserAccess(username);
        Object loginFailedReason = "";
        String userLicenseState = isUserHasAccess ? "licensed" : "unlicensed";
        this.log.trace("userLookupService.isUserHasAccess -> " + isUserHasAccess);
        TraditionalLoginUtils.TraditionalLoginStatus status = TraditionalLoginUtils.evaluateIfUserShouldBeAllowedToLogin(this.kerbConfManager, this.userLookupService, this.hostApp, username);
        switch (status) {
            case ALLOWED_FOR_EVERYONE: 
            case ALLOWED_FOR_USER: {
                chain.doFilterKssoKeepWrapped(cachedRequest, res);
                return;
            }
            case PREVENTED_FOR_USER: {
                loginFailedReason = "Preventing traditional login for " + userLicenseState + " user. User did not have permitted groups / user directory.";
                break;
            }
            case PREVENTED_FOR_EVERYONE: {
                loginFailedReason = "Preventing traditional login for " + userLicenseState + " user. Traditional login is prevented for all " + userLicenseState + " users.";
            }
        }
        this.auditLogFacade.loginFailed(username, "Traditional Username/Password login", (String)loginFailedReason);
        this.log.trace((String)loginFailedReason);
        this.renderTraditionalLoginErrorPage(cachedRequest, res);
    }

    private boolean avoidEditUserInCloudDirectory(FilterChainFacade chain, HttpServletRequestFacade req, HttpServletResponseFacade res) throws IOException {
        UserProfile user = null;
        if (this.hostApp.isEditAccountPostRequest(req)) {
            user = UserManagerUtils.getLoggedInUser((UserManager)this.userManager, (HttpServletRequestFacade)req);
        }
        if (this.hostApp.isAdminEditAccountPostRequest(req)) {
            user = this.hostApp.getEditAccountUser(this.userManager, req);
        }
        if (user != null && AvoidNameEmailChange.isUserInCloudDirectory(user, this.hostApp, this.scimConfManager, this.connectorConfManager) && (!StringUtils.equals((CharSequence)user.getFullName(), (CharSequence)this.hostApp.getEditAccountName(req)) || !StringUtils.equals((CharSequence)user.getEmail(), (CharSequence)this.hostApp.getEditAccountEmail(req)) || req.getParameter("username") != null && !StringUtils.equals((CharSequence)user.getUsername(), (CharSequence)req.getParameter("username")))) {
            res.sendError(405, "Editing a user's attributes is blocked in a cloud user directory.");
            return true;
        }
        return false;
    }

    private void sendJsmErrorBody(HttpServletResponseFacade res) throws IOException {
        res.setContentType("application/json");
        res.getWriter().print("{\"loginSucceeded\":false,\"loginError\":false,\"communicationError\":false,\"elevatedSecurityCheckShown\":false,\"captchaFailure\":false,\"loginFailedByPermissions\":false,\"passwordResetRequired\":false}");
    }

    private void renderTraditionalLoginErrorPage(HttpServletRequestFacade req, HttpServletResponseFacade res) throws IOException {
        String errorMessage = this.kerbConfManager.getTraditionalLoginDisabledMessage();
        if (StringUtils.contains((CharSequence)this.kerbConfManager.getTraditionalLoginDisabledMessage(), (CharSequence)"%s%s")) {
            errorMessage = String.format(this.kerbConfManager.getTraditionalLoginDisabledMessage(), req.getContextPath(), this.hostApp.getLoginPage());
        }
        res.setContentType("text/html");
        if (this.hostApp.shouldUseLegacyLoginExperience() && this.hostApp.isJsmLoginPage(req)) {
            res.addHeader("Set-Cookie", CookieUtil.getCookieString("TraditionalLoginBlockedMessage", errorMessage, "/"));
        }
        res.getWriter().print(errorMessage);
    }

    public void destroy() {
    }

    private boolean isProductMatch() {
        for (String product : this.products) {
            if (!this.hostApp.isProductMatch(product)) continue;
            return true;
        }
        return false;
    }

    public void initKssoFilter(FilterConfigFacade filterConfig) {
        String productsParam = filterConfig.getInitParameter("products");
        if (productsParam != null) {
            this.products = productsParam.split(",");
            for (int i = 0; i < this.products.length; ++i) {
                this.products[i] = this.products[i].trim().toLowerCase();
            }
        }
    }

    private HttpServletRequestFacade wrapScimAuthHeader(HttpServletRequestFacade request) {
        return new HttpServletRequestFacade(request.getHttpServletRequest()){
            private Set<String> headerNameSet;

            public Enumeration<String> getHeaderNames() {
                if (this.headerNameSet == null) {
                    this.headerNameSet = new HashSet<String>();
                    Enumeration wrappedHeaderNames = super.getHeaderNames();
                    while (wrappedHeaderNames.hasMoreElements()) {
                        String headerName = (String)wrappedHeaderNames.nextElement();
                        if ("Authorization".equalsIgnoreCase(headerName)) {
                            this.headerNameSet.add("ScimAuthorization");
                            continue;
                        }
                        this.headerNameSet.add(headerName);
                    }
                }
                return Collections.enumeration(this.headerNameSet);
            }

            public Enumeration<String> getHeaders(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return Collections.emptyEnumeration();
                }
                if ("ScimAuthorization".equalsIgnoreCase(name)) {
                    return super.getHeaders("Authorization");
                }
                return super.getHeaders(name);
            }

            public String getHeader(String name) {
                if ("Authorization".equalsIgnoreCase(name)) {
                    return null;
                }
                if ("ScimAuthorization".equalsIgnoreCase(name)) {
                    return super.getHeader("Authorization");
                }
                return super.getHeader(name);
            }
        };
    }
}

