/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb.backup;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import io.vavr.collection.HashSet;
import io.vavr.collection.Map;
import io.vavr.collection.Set;
import io.vavr.control.Option;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kantega.shaded.com.fasterxml.jackson.core.JsonFactory;
import kantega.shaded.com.fasterxml.jackson.core.JsonGenerator;
import kantega.shaded.com.fasterxml.jackson.core.JsonParser;
import kantega.shaded.com.fasterxml.jackson.core.StreamReadFeature;
import kantega.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.PluginKey;
import org.kantega.atlaskerb.apiserver.ApiServer;
import org.kantega.atlaskerb.apiserver.ApiServerConfManager;
import org.kantega.atlaskerb.apitokens.ApiTokenService;
import org.kantega.atlaskerb.backup.BackupInfo;
import org.kantega.atlaskerb.backup.ScimTransform;
import org.kantega.atlaskerb.config.ConfigNameSpaces;
import org.kantega.atlaskerb.connector.ConnectorConfManager;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.hostapp.HostAppFactory;
import org.kantega.atlaskerb.restapi.access.TokenEndpointService;
import org.kantega.atlaskerb.saml.IdpConfManager;
import org.kantega.atlaskerb.scim.ScimConfManager;
import org.kantega.atlaskerb.utils.JsonWrapper;
import org.kantega.atlaskerb.utils.ListParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BackupService {
    public static final String BACKUP_DIR = "SNAPSHOT/";
    public static final String PLUGIN_SETTINGS_PROPERTIES = "SNAPSHOT/plugin-settings.properties";
    public static final String BACKUP_PROPERTIES = "SNAPSHOT/snapshot.properties";
    public static final String SCIM_DIR = "SNAPSHOT/scim/";
    public static final String SCIM_DIRECTORIES_FILE = "SNAPSHOT/scim/scim-directories.json";
    private final Logger log = LoggerFactory.getLogger(BackupService.class);
    private final HostApp hostApp;
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final ConnectorConfManager connectorConfManager;
    private final ApiServerConfManager apiServerConfManager;
    private final ApiServer apiServer;
    private final ApplicationProperties applicationProperties;
    private final ApiTokenService apiTokenService;
    private final TokenEndpointService tokenEndpointService;
    private final ScimConfManager scimConfManager;
    private final JsonWrapper jsonWrapper;

    @Inject
    public BackupService(@ComponentImport ApplicationProperties applicationProperties, HostAppFactory hostAppFactory, KerbConfManager kerbConfManager, IdpConfManager idpConfManager, ConnectorConfManager connectorConfManager, ApiServerConfManager apiServerConfManager, ApiServer apiServer, ApiTokenService apiTokenService, TokenEndpointService tokenEndpointService, ScimConfManager scimConfManager, JsonWrapper jsonWrapper) {
        this.hostApp = hostAppFactory.getInstance();
        this.kerbConfManager = kerbConfManager;
        this.idpConfManager = idpConfManager;
        this.connectorConfManager = connectorConfManager;
        this.apiServerConfManager = apiServerConfManager;
        this.apiServer = apiServer;
        this.applicationProperties = applicationProperties;
        this.apiTokenService = apiTokenService;
        this.tokenEndpointService = tokenEndpointService;
        this.scimConfManager = scimConfManager;
        this.jsonWrapper = jsonWrapper;
    }

    public void restoreFromFile(File backupFile, boolean makeBackup, java.util.Set<ConfigNameSpaces.ConfigSubset> configOptions) {
        if (makeBackup) {
            File file = this.createBackup("Before restore of " + backupFile.getName());
        }
        File homeDirectory = this.hostApp.getHomeDirectory();
        File unpackDir = new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_restore");
        File oldHomeDir = new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_oldhome");
        this.log.info("Restoring KSSO config from " + backupFile.getAbsolutePath() + " to " + homeDirectory.getAbsolutePath());
        this.log.info("Restoring settings: " + configOptions.stream().map(ConfigNameSpaces.ConfigSubset::getDisplayName).reduce("", (a, b) -> a + ", " + b));
        try (ZipInputStream in = new ZipInputStream(Files.newInputStream(backupFile.toPath(), new OpenOption[0]));){
            Properties props = new Properties();
            this.unpackZipFile(in, props, unpackDir);
            if (configOptions.containsAll(Arrays.asList(ConfigNameSpaces.ConfigSubset.values()))) {
                BackupService.restoreEntireBackupInHomeDirectory(unpackDir, homeDirectory, oldHomeDir);
            } else {
                this.partiallyRestoreConfigThatWasSelected(unpackDir, homeDirectory, oldHomeDir, configOptions);
            }
            if (oldHomeDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)oldHomeDir);
                }
                catch (IOException e) {
                    this.log.error("Failed to delete old home directory: ", (Throwable)e);
                }
            }
            this.restoreDatabaseSettings(configOptions, props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                FileUtils.deleteDirectory((File)unpackDir);
            }
            catch (IOException e) {
                this.log.warn("Failed to delete unpack directory: ", (Throwable)e);
            }
        }
    }

    private void restoreDatabaseSettings(java.util.Set<ConfigNameSpaces.ConfigSubset> configOptions, Properties props) {
        this.kerbConfManager.restoreSettings(props, configOptions);
        this.idpConfManager.restoreSettings(props, configOptions);
        this.scimConfManager.restoreSettings(props, configOptions);
        this.connectorConfManager.restoreSettings(props, configOptions);
        this.apiServerConfManager.restoreSettings(props, configOptions);
        this.apiServer.restoreSettings(configOptions);
        this.tokenEndpointService.restoreEndpoints(props, configOptions);
        this.apiTokenService.restoreTokens(props, configOptions);
        this.kerbConfManager.flushCaches();
    }

    private void unpackZipFile(ZipInputStream in, Properties props, File unpackDir) throws IOException {
        ZipEntry entry;
        while ((entry = in.getNextEntry()) != null) {
            String entryName = entry.getName();
            this.log.debug("Entry: " + entry.getName());
            if (entry.isDirectory()) continue;
            if (entry.getName().equals(PLUGIN_SETTINGS_PROPERTIES)) {
                this.log.debug("Restoring plugin settings");
                props.load(in);
                continue;
            }
            if (!entry.getName().startsWith(BACKUP_DIR)) {
                File file = new File(unpackDir, entry.getName());
                this.log.debug("Restoring entry: " + entryName);
                file.getParentFile().mkdirs();
                Files.copy(in, file.toPath(), new CopyOption[0]);
                continue;
            }
            if (!entry.getName().equals(SCIM_DIRECTORIES_FILE)) continue;
            this.log.debug("Restoring SCIM directories");
            this.restoreScimDirectories(in);
        }
    }

    private void partiallyRestoreConfigThatWasSelected(File unpackDir, File homeDirectory, File oldHomeDir, java.util.Set<ConfigNameSpaces.ConfigSubset> configOptions) throws IOException {
        HashSet allConfigSets = HashSet.ofAll(Arrays.asList(ConfigNameSpaces.ConfigSubset.values()));
        HashSet allKssoFilenames = HashSet.ofAll(KerbConfManager.getFileNamesFromConfigSubset(allConfigSets.toJavaSet())).addAll(IdpConfManager.getFileNamesFromConfigSubset(allConfigSets.toJavaSet())).addAll(ScimConfManager.getFileNamesFromConfigSubset(allConfigSets.toJavaSet())).addAll(ConnectorConfManager.getFileNamesFromConfigSubset(allConfigSets.toJavaSet()));
        HashSet filenamesToRestore = HashSet.ofAll(KerbConfManager.getFileNamesFromConfigSubset(configOptions)).addAll(IdpConfManager.getFileNamesFromConfigSubset(configOptions)).addAll(ScimConfManager.getFileNamesFromConfigSubset(configOptions)).addAll(ConnectorConfManager.getFileNamesFromConfigSubset(configOptions));
        Set fileNamesToKeepInDirectory = allKssoFilenames.diff((Set)filenamesToRestore);
        this.log.info("Restoring files: " + (String)filenamesToRestore.foldLeft((Object)"", (a, b) -> a + ", " + b));
        this.log.info("Retaining files: " + (String)fileNamesToKeepInDirectory.foldLeft((Object)"", (a, b) -> a + ", " + b));
        if (this.log.isDebugEnabled()) {
            try (Stream<Path> listUnpackDirStream = Files.walk(Paths.get(unpackDir.getAbsolutePath(), new String[0]), new FileVisitOption[0]);){
                java.util.Set files = listUnpackDirStream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(Path::getFileName).map(Path::toString).collect(Collectors.toSet());
                this.log.debug("Files in unpackDir: " + ListParseUtils.iterableToCommaSeparatedString(files));
            }
        }
        Path unpackDirPath = Paths.get(unpackDir.getAbsolutePath(), new String[0]);
        Path homeDirPath = Paths.get(homeDirectory.getAbsolutePath(), new String[0]);
        if (homeDirectory.exists() && homeDirectory.isDirectory()) {
            FileUtils.copyDirectory((File)homeDirectory, (File)oldHomeDir);
        }
        try (Stream<Path> walkHomeDir = Files.walk(homeDirPath, new FileVisitOption[0]);){
            walkHomeDir.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(arg_0 -> BackupService.lambda$partiallyRestoreConfigThatWasSelected$5((Set)filenamesToRestore, arg_0)).forEach(path -> {
                try {
                    Files.delete(path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try (Stream<Path> walkUnpackDir = Files.walk(unpackDirPath, new FileVisitOption[0]);){
            walkUnpackDir.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(arg_0 -> BackupService.lambda$partiallyRestoreConfigThatWasSelected$8((Set)filenamesToRestore, arg_0)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(path -> {
                Path relativePath = unpackDirPath.relativize((Path)path);
                Path targetPath = homeDirPath.resolve(relativePath);
                try {
                    if (!Files.exists(targetPath.getParent(), new LinkOption[0])) {
                        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                    }
                    Files.move(path, targetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void restoreEntireBackupInHomeDirectory(File unpackDir, File homeDirectory, File oldHomeDir) throws IOException {
        if (unpackDir.exists() && unpackDir.isDirectory()) {
            if (homeDirectory.exists() && homeDirectory.isDirectory()) {
                FileUtils.moveDirectory((File)homeDirectory, (File)oldHomeDir);
            }
            FileUtils.moveDirectory((File)unpackDir, (File)homeDirectory);
        }
    }

    private static boolean shouldRestoreFile(Set<String> fileNamesToRestore, String path) {
        return HashSet.ofAll(fileNamesToRestore).exists(fileName -> path.contains((CharSequence)fileName));
    }

    public File createBackup(String description) {
        BackupInfo backupInfo = this.getBackupInfo(description);
        final File homeDirectory = this.hostApp.getHomeDirectory();
        File backupsDirectory = this.getBackupsDirectory();
        File tempFile = new File(backupsDirectory, "_backup_zip.tmp");
        tempFile.getParentFile().mkdirs();
        try (final ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));){
            this.writeMetadata(out, backupInfo);
            this.writeDbSettings(out);
            this.writeScimDirectories(out, this.scimConfManager.findScimDirectories());
            if (homeDirectory.exists()) {
                Files.walkFileTree(homeDirectory.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        ZipEntry entry = new ZipEntry(homeDirectory.toPath().relativize(path).toString());
                        out.putNextEntry(entry);
                        Files.copy(path, out);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (IOException e) {
            this.log.error("Failed to create KSSO backup tempfile: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            File backupFile = new File(tempFile.getParentFile(), this.filename());
            Path backupFilePath = Paths.get(backupFile.getAbsolutePath(), new String[0]);
            Path tempFilePath = Paths.get(tempFile.getAbsolutePath(), new String[0]);
            Files.move(tempFilePath, backupFilePath, StandardCopyOption.REPLACE_EXISTING);
            return backupFile;
        }
        catch (IOException e) {
            this.log.error("Failed to finalize the creation of KSSO backup .zip file: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private BackupInfo getBackupInfo(String description) {
        return new BackupInfo(this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), PluginKey.getVersion(), this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE), System.currentTimeMillis(), description, this.filename());
    }

    @NotNull
    public String filename() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd-HH_mm_ss");
        return "sso-backup-" + df.format(new Date()) + ".zip";
    }

    private void writeDbSettings(ZipOutputStream out) throws IOException {
        ZipEntry propsFile = new ZipEntry(PLUGIN_SETTINGS_PROPERTIES);
        out.putNextEntry(propsFile);
        Properties props = this.getAllDbSettings();
        props.store(out, null);
    }

    private void writeMetadata(ZipOutputStream out, BackupInfo backupInfo) throws IOException {
        ZipEntry propsFile = new ZipEntry(BACKUP_PROPERTIES);
        out.putNextEntry(propsFile);
        Properties settings = backupInfo.getProperties();
        settings.store(out, null);
    }

    public void restoreScimDirectories(InputStream is) throws IOException {
        ScimTransform scimTransform = (ScimTransform)this.jsonWrapper.objectReader().without(StreamReadFeature.AUTO_CLOSE_SOURCE).readValue(is, ScimTransform.class);
        List storedTenantIds = io.vavr.collection.List.ofAll(scimTransform.getScimUserDirectoryTransforms()).map(dir -> dir.attrs.get("ksso.scim.tenantId")).toJavaList();
        this.scimConfManager.getScimDirectories().filter(scimDirectory -> !storedTenantIds.contains(scimDirectory.getTenantId())).forEach(scimDirectory -> this.scimConfManager.deleteInternalDirectory(scimDirectory.getDirectoryId()));
        scimTransform.getScimUserDirectoryTransforms().forEach(scimDirTransform -> this.scimConfManager.restoreScimDirectory(scimDirTransform.name, scimDirTransform.attrs));
    }

    private void writeScimDirectories(ZipOutputStream out, Map<String, Directory> scimDirectories) throws IOException {
        if (scimDirectories.size() < 1) {
            return;
        }
        ScimTransform scimOverview = new ScimTransform(scimDirectories);
        out.putNextEntry(new ZipEntry(SCIM_DIRECTORIES_FILE));
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        jsonFactory.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        mapper.writeValue((OutputStream)out, (Object)scimOverview);
        out.closeEntry();
    }

    private Properties getAllDbSettings() {
        Properties props = new Properties();
        props.putAll(this.kerbConfManager.getSettings());
        props.putAll(this.idpConfManager.getSettings());
        props.putAll(this.connectorConfManager.getSettings());
        props.putAll(this.apiServerConfManager.getSettings());
        props.put("apiTokens", this.apiTokenService.getAllTokensAsJsonForBackup());
        props.put("restrictAPIEndpoints", this.tokenEndpointService.getAllEndpointsAsJson());
        props.putAll(this.scimConfManager.getSettings());
        return props;
    }

    public File getBackupsDirectory() {
        File homeDirectory = this.hostApp.getHomeDirectory();
        return new File(homeDirectory.getParentFile(), homeDirectory.getName() + "_snapshots");
    }

    public List<BackupInfo> getBackups() {
        File[] files = this.getBackupsDirectory().listFiles(pathname -> pathname.getName().endsWith(".zip"));
        if (files == null) {
            return Collections.emptyList();
        }
        Arrays.sort(files, (o1, o2) -> Long.compare(o2.lastModified(), o1.lastModified()));
        ArrayList<BackupInfo> result = new ArrayList<BackupInfo>();
        for (File file : files) {
            if (!file.canRead()) {
                result.add(new BackupInfo(file.getName(), false));
                continue;
            }
            try (ZipFile zip = new ZipFile(file);){
                ZipEntry metaEntry = zip.getEntry(BACKUP_PROPERTIES);
                ZipEntry settingsEntry = zip.getEntry(PLUGIN_SETTINGS_PROPERTIES);
                if (metaEntry == null || settingsEntry == null) continue;
                Properties props = new Properties();
                props.load(zip.getInputStream(metaEntry));
                BackupInfo info = BackupInfo.fromProperties(props, file.getName());
                result.add(info);
                Properties settings = new Properties();
                settings.load(zip.getInputStream(settingsEntry));
                info.setSettings(settings);
                TreeSet<String> paths = new TreeSet<String>();
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || entry.getName().startsWith(BACKUP_DIR)) continue;
                    paths.add(entry.getName());
                }
                info.getPaths().addAll(paths);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public boolean isBackup(String filename) {
        return io.vavr.collection.List.ofAll(this.getBackups()).find(backupInfo -> backupInfo.getFilename().equals(filename)).isDefined();
    }

    public BackupInfo findBackup(String filename) {
        return (BackupInfo)io.vavr.collection.List.ofAll(this.getBackups()).find(backupInfo -> backupInfo.getFilename().equals(filename)).getOrNull();
    }

    public Option<File> getBackupFile(String filename) {
        return io.vavr.collection.List.ofAll(this.getBackups()).find(backupInfo -> backupInfo.getFilename().equals(filename)).map(backupInfo -> new File(this.getBackupsDirectory(), backupInfo.getFilename()));
    }

    private static /* synthetic */ boolean lambda$partiallyRestoreConfigThatWasSelected$8(Set filenamesToRestore, Path path) {
        return BackupService.shouldRestoreFile((Set<String>)filenamesToRestore, path.toString());
    }

    private static /* synthetic */ boolean lambda$partiallyRestoreConfigThatWasSelected$5(Set filenamesToRestore, Path path) {
        return BackupService.shouldRestoreFile((Set<String>)filenamesToRestore, path.toString());
    }
}

