/*
 * Decompiled with CFR 0.152.
 */
package org.kantega.atlaskerb;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.kantegasso.servlet.http.HttpServletRequestFacade;
import com.kantegasso.servlet.http.HttpServletResponseFacade;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.kantega.atlaskerb.KerbConfManager;
import org.kantega.atlaskerb.RequireAdminServlet;
import org.kantega.atlaskerb.RequireAdminServletDependencyBucket;
import org.kantega.atlaskerb.hostapp.HostApp;
import org.kantega.atlaskerb.saml.IdpConfManager;

public class ConfigureForceLoginServlet
extends RequireAdminServlet {
    private final KerbConfManager kerbConfManager;
    private final IdpConfManager idpConfManager;
    private final TemplateRenderer renderer;
    private final ApplicationProperties applicationProperties;
    private final HostApp hostApp;

    @Inject
    public ConfigureForceLoginServlet(RequireAdminServletDependencyBucket bucket) {
        super(bucket);
        this.kerbConfManager = bucket.getKerbConfManager();
        this.idpConfManager = bucket.getIdpConfManager();
        this.renderer = bucket.getTemplateRenderer();
        this.applicationProperties = bucket.getApplicationProperties();
        this.hostApp = bucket.getHostApp();
    }

    protected void doGetKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        Map<String, Object> model = this.newModel(req);
        model.put("topMenu", "dashboard");
        model.put("menuItem", "force-login");
        model.put("require_login", this.kerbConfManager.isRequireLogin());
        model.put("sendToDashboardAfterLogin", this.kerbConfManager.isSendToDashboardAfterLogin());
        model.put("login_mode", this.kerbConfManager.isForceLogin() ? "force_login" : "attempt_login");
        model.put("requireLoginPathMappings", this.hostApp.getRequireLoginPathMappings());
        model.put("forcedSsoUrls", this.kerbConfManager.getForcedSsoUrls());
        String contextPath = req.getContextPath();
        model.put("contextPath", contextPath);
        Set<String> excludedPaths = this.kerbConfManager.getRequireLoginExcludedPaths();
        excludedPaths.removeAll(this.kerbConfManager.getDefaultRequireLoginExcludedPaths());
        model.put("excludedPaths", excludedPaths);
        model.put("defaultExcludedPaths", this.kerbConfManager.getDefaultRequireLoginExcludedPaths());
        model.put("displayName", this.applicationProperties.getDisplayName());
        resp.setContentType("text/html");
        this.renderer.render("templates/atlaskerb/force-login.vm", model, (Writer)resp.getWriter());
    }

    @Override
    protected void doPostKsso(HttpServletRequestFacade req, HttpServletResponseFacade resp) throws IOException {
        super.doPostKsso(req, resp);
        if (req.getParameter("require_login_saved") != null) {
            this.kerbConfManager.setRequireLogin("on".equals(req.getParameter("require_login")));
            this.kerbConfManager.setForceLogin(!"attempt_login".equals(req.getParameter("login_mode")));
            ConfigureForceLoginServlet.sendSuccess(resp);
        } else if (req.getParameter("dashboardAfterLogin_saved") != null) {
            this.kerbConfManager.setSendToDashboardAfterLogin("on".equals(req.getParameter("sendToDashboardAfterLogin")));
            ConfigureForceLoginServlet.sendSuccess(resp);
        } else {
            String baseUrl;
            Object addUrl;
            String removeUrl = req.getParameter("removeUrl");
            if (StringUtils.isNotBlank((CharSequence)removeUrl)) {
                this.kerbConfManager.removeForcedSsoUrls(removeUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)(removeUrl = req.getParameter("removeExcludedUrl")))) {
                this.kerbConfManager.removePreemptiveAuthExcludedPaths(removeUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)(addUrl = req.getParameter("addUrl")))) {
                addUrl = ((String)addUrl).trim();
                baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
                addUrl = StringUtils.removeStart((String)addUrl, (String)baseUrl);
                addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"https://"));
                if (!StringUtils.startsWith((CharSequence)(addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"http://"))), (CharSequence)"/")) {
                    addUrl = "/" + (String)addUrl;
                }
                this.kerbConfManager.addForcedSsoUrls((String)addUrl);
            }
            if (StringUtils.isNotBlank((CharSequence)(addUrl = req.getParameter("excludedUrl")))) {
                addUrl = ((String)addUrl).trim();
                baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
                addUrl = StringUtils.removeStart((String)addUrl, (String)baseUrl);
                addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"https://"));
                if (!StringUtils.startsWith((CharSequence)(addUrl = StringUtils.removeStart((String)addUrl, (String)StringUtils.removeStart((String)baseUrl, (String)"http://"))), (CharSequence)"/")) {
                    addUrl = "/" + (String)addUrl;
                }
                this.kerbConfManager.addPreemptiveAuthExcludedPaths((String)addUrl);
            }
            resp.sendRedirect("force-login");
        }
    }

    private static void sendSuccess(HttpServletResponseFacade response) throws IOException {
        response.setStatus(200);
        response.getWriter().print("<html>Settings was saved</html>");
    }
}

