/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview.viewissue;

import com.almworks.jira.psdpreview.LicenseManager;
import com.almworks.jira.psdpreview.PsdAwareThumbnailManager;
import com.almworks.jira.psdpreview.PsdThumbnailCreatorImpl;
import com.almworks.jira.psdpreview.viewissue.AttachmentBlockContextHelper;
import com.almworks.jira.psdpreview.viewissue.AttachmentBlockContextProvider;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentsCategoriser;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.util.FileIconUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OnlyPsdAttachmentBlockContextProvider
extends AttachmentBlockContextProvider {
    private final PsdThumbnailCreatorImpl psdThumbnailCreator;
    private final LicenseManager licenseManager;
    private final PsdAwareThumbnailManager thumbnailManager;

    public OnlyPsdAttachmentBlockContextProvider(AttachmentManager attachmentManager, JiraAuthenticationContext authenticationContext, ThumbnailManager thumbnailManager, UserManager userManager, FileIconUtil fileIconUtil, DateTimeFormatter dateTimeFormatter, AttachmentBlockContextHelper helper, PsdThumbnailCreatorImpl psdThumbnailCreator, LicenseManager licenseManager, PermissionManager permissionManager) {
        super(attachmentManager, authenticationContext, thumbnailManager, userManager, fileIconUtil, dateTimeFormatter, helper, psdThumbnailCreator, licenseManager, permissionManager);
        this.psdThumbnailCreator = psdThumbnailCreator;
        this.thumbnailManager = new PsdAwareThumbnailManager(thumbnailManager, psdThumbnailCreator);
        this.licenseManager = licenseManager;
    }

    @Override
    protected AttachmentsCategoriser getAttachmentsCategoriser(final Map<Long, Boolean> psdFlags, final List<Attachment> attachments) {
        return new AttachmentsCategoriser((ThumbnailManager)this.thumbnailManager, new AttachmentsCategoriser.Source(){

            public List<Attachment> getAttachments() {
                ArrayList<Attachment> psdAttachments = new ArrayList<Attachment>();
                for (Attachment attachment : attachments) {
                    PsdThumbnailCreatorImpl thumbnailCreator = OnlyPsdAttachmentBlockContextProvider.this.psdThumbnailCreator;
                    if (!thumbnailCreator.isPsdFileAndSupported(attachment)) continue;
                    psdFlags.put(attachment.getId(), true);
                    if (OnlyPsdAttachmentBlockContextProvider.this.licenseManager.isLicenseExpired()) continue;
                    psdAttachments.add(attachment);
                    attachment.getGenericValue().set("thumbnailable", (Object)1);
                }
                return psdAttachments;
            }
        });
    }

    private AttachmentsCategoriser emptyCategoriser() {
        return new AttachmentsCategoriser((ThumbnailManager)this.thumbnailManager, new AttachmentsCategoriser.Source(){

            public List<Attachment> getAttachments() {
                return Collections.emptyList();
            }
        });
    }
}

