/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview.viewissue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class AttachmentSortingOptionsFactory
implements SimpleLinkFactory {
    private final VelocityRequestContextFactory requestContextFactory;
    private final JiraAuthenticationContext authenticationContext;

    public AttachmentSortingOptionsFactory(VelocityRequestContextFactory requestContextFactory, JiraAuthenticationContext authenticationContext) {
        this.requestContextFactory = requestContextFactory;
        this.authenticationContext = authenticationContext;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    public List<SimpleLink> getLinks(ApplicationUser applicationUser, Map<String, Object> params) {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        Issue issue = (Issue)params.get("issue");
        VelocityRequestSession session = requestContext.getSession();
        String baseUrl = requestContext.getBaseUrl();
        String sortingOrder = (String)session.getAttribute("jira.issue.attachment.sortby");
        boolean sortedByName = "fileName".equals(sortingOrder) || StringUtils.isBlank((String)sortingOrder);
        SimpleLinkImpl allLink = new SimpleLinkImpl("attachment-sort-key-name", i18n.getText("viewissue.attachments.sort.key.name"), i18n.getText("viewissue.subtasks.tab.show.all.name"), null, sortedByName ? "aui-list-checked aui-checked" : "aui-list-checked", baseUrl + "/browse/" + issue.getKey() + "?attachmentSortBy=fileName#attachmentmodule", null);
        SimpleLinkImpl openLink = new SimpleLinkImpl("attachment-sort-key-date", i18n.getText("viewissue.attachments.sort.key.date"), i18n.getText("viewissue.attachments.sort.key.date"), null, !sortedByName ? "aui-list-checked aui-checked" : "aui-list-checked", baseUrl + "/browse/" + issue.getKey() + "?attachmentSortBy=dateTime#attachmentmodule", null);
        return CollectionBuilder.list((Object[])new SimpleLink[]{allLink, openLink});
    }
}

