/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview.viewissue;

import com.almworks.jira.psdpreview.LicenseManager;
import com.almworks.jira.psdpreview.PsdAwareThumbnailManager;
import com.almworks.jira.psdpreview.PsdThumbnailCreatorImpl;
import com.almworks.jira.psdpreview.viewissue.AttachmentBlockContextHelper;
import com.atlassian.core.util.FileSize;
import com.atlassian.jira.bc.issue.attachment.FileNameBasedVersionedAttachmentsList;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCreationDateComparator;
import com.atlassian.jira.issue.attachment.AttachmentFileNameCreationDateComparator;
import com.atlassian.jira.issue.attachment.AttachmentItem;
import com.atlassian.jira.issue.attachment.AttachmentItems;
import com.atlassian.jira.issue.attachment.AttachmentZipKit;
import com.atlassian.jira.issue.attachment.AttachmentsCategoriser;
import com.atlassian.jira.issue.attachment.MimetypesFileTypeMap;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.bean.NonZipExpandableExtensions;
import com.atlassian.jira.web.util.FileIconBean;
import com.atlassian.jira.web.util.FileIconUtil;
import com.atlassian.plugin.PluginParseException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;

public class AttachmentBlockContextProvider
implements CacheableContextProvider {
    private static final Set<String> WELL_KNOWN_MIMETYPES = new LinkedHashSet<String>();
    private final AttachmentManager attachmentManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PsdThumbnailCreatorImpl psdThumbnailCreator;
    private final LicenseManager licenseManager;
    private final PermissionManager permissionManager;
    private final PsdAwareThumbnailManager thumbnailManager;
    private final UserManager userManager;
    private final NonZipExpandableExtensions nonZipExpandableExtensions;
    private final FileIconUtil fileIconUtil;
    private final DateTimeFormatter dateTimeFormatter;
    private final AttachmentZipKit attachmentZipKit;
    private final AttachmentBlockContextHelper helper;

    public AttachmentBlockContextProvider(AttachmentManager attachmentManager, JiraAuthenticationContext authenticationContext, ThumbnailManager thumbnailManager, UserManager userManager, FileIconUtil fileIconUtil, DateTimeFormatter dateTimeFormatter, AttachmentBlockContextHelper helper, PsdThumbnailCreatorImpl psdThumbnailCreator, LicenseManager licenseManager, PermissionManager permissionManager) {
        this.attachmentManager = attachmentManager;
        this.authenticationContext = authenticationContext;
        this.psdThumbnailCreator = psdThumbnailCreator;
        this.licenseManager = licenseManager;
        this.permissionManager = permissionManager;
        this.thumbnailManager = new PsdAwareThumbnailManager(thumbnailManager, psdThumbnailCreator);
        this.userManager = userManager;
        this.nonZipExpandableExtensions = (NonZipExpandableExtensions)ComponentAccessor.getComponent(NonZipExpandableExtensions.class);
        this.fileIconUtil = fileIconUtil;
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE) : null;
        this.attachmentZipKit = new AttachmentZipKit();
        this.helper = helper;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        MapBuilder paramsBuilder = MapBuilder.newBuilder(context);
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getUser();
        boolean zipEnabled = this.helper.getZipSupport();
        HashMap<Long, Boolean> psdFlags = new HashMap<Long, Boolean>();
        List attachments = this.attachmentManager.getAttachments(issue, this.attachmentComparator());
        AttachmentsCategoriser categoriser = this.getAttachmentsCategoriser(psdFlags, attachments);
        AttachmentItems attachmentsWithThumbs = categoriser.itemsThatHaveThumbs();
        AttachmentItems attachmentsWithoutThumbs = categoriser.itemsThatDoNotHaveThumbs();
        boolean hasAnyPsdAttachment = psdFlags.containsValue(Boolean.TRUE);
        paramsBuilder.add((Object)"licenseExpired", (Object)this.licenseManager.isLicenseExpired());
        paramsBuilder.add((Object)"userIsAdmin", (Object)this.permissionManager.hasPermission(44, user));
        paramsBuilder.add((Object)"iconGenerator", (Object)new IconGenerator());
        paramsBuilder.add((Object)"fileSizeFormatter", (Object)new FileSize());
        paramsBuilder.add((Object)"hasAttachments", (Object)(!categoriser.items().isEmpty() || hasAnyPsdAttachment ? 1 : 0));
        paramsBuilder.add((Object)"openSquareBracket", (Object)JiraUrlCodec.encode((String)"["));
        paramsBuilder.add((Object)"closeSquareBracket", (Object)JiraUrlCodec.encode((String)"]"));
        paramsBuilder.add((Object)"imageAttachments", this.convertToSimpleAttachments(issue, attachmentsWithThumbs, zipEnabled, user, psdFlags));
        paramsBuilder.add((Object)"fileAttachments", this.convertToSimpleAttachments(issue, attachmentsWithoutThumbs, zipEnabled, user, psdFlags));
        paramsBuilder.add((Object)"maximumNumberOfZipEntriesToShow", (Object)this.helper.getMaximumNumberOfZipEntriesToShow());
        paramsBuilder.add((Object)"fullBaseUrl", (Object)JiraUrl.constructBaseUrl((HttpServletRequest)AttachmentBlockContextProvider.getRequest(context)));
        paramsBuilder.add((Object)"hasPSDAttachments", (Object)hasAnyPsdAttachment);
        return paramsBuilder.toMap();
    }

    protected AttachmentsCategoriser getAttachmentsCategoriser(final Map<Long, Boolean> psdFlags, final List<Attachment> attachments) {
        return new AttachmentsCategoriser((ThumbnailManager)this.thumbnailManager, new AttachmentsCategoriser.Source(){

            public List<Attachment> getAttachments() {
                for (Attachment attachment : attachments) {
                    if (AttachmentBlockContextProvider.this.psdThumbnailCreator.isPsdFileAndSupported(attachment)) {
                        psdFlags.put(attachment.getId(), true);
                        if (AttachmentBlockContextProvider.this.licenseManager.isLicenseExpired()) continue;
                        attachment.getGenericValue().set("thumbnailable", (Object)1);
                        continue;
                    }
                    psdFlags.put(attachment.getId(), false);
                }
                return attachments;
            }
        });
    }

    protected Comparator<Attachment> attachmentComparator() {
        String attachmentSortBy = this.helper.getAttachmentSortBy();
        String attachmentOrder = this.helper.getAttachmentOrder();
        Object attachmentComparator = "dateTime".equals(attachmentSortBy) ? new AttachmentCreationDateComparator() : new AttachmentFileNameCreationDateComparator(this.authenticationContext.getLocale());
        if ("desc".equals(attachmentOrder)) {
            attachmentComparator = Collections.reverseOrder(attachmentComparator);
        }
        return attachmentComparator;
    }

    private List<SimpleAttachment> convertToSimpleAttachments(Issue issue, AttachmentItems items, boolean zipEnabled, ApplicationUser user, Map<Long, Boolean> psdFlags) {
        FileNameBasedVersionedAttachmentsList attachmentsList = new FileNameBasedVersionedAttachmentsList(items.attachments());
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        for (AttachmentItem item : items) {
            Attachment attachment = item.attachment();
            boolean latestVersion = attachmentsList.isLatestVersion(attachment);
            boolean shouldExpandAsZip = false;
            if (zipEnabled) {
                shouldExpandAsZip = this.shouldExpandAsZip(issue, attachment);
            }
            boolean canDelete = this.helper.canDeleteAttachment(issue, attachment, user);
            builder.add((Object)new SimpleAttachment(attachment, latestVersion, shouldExpandAsZip, psdFlags.get(attachment.getId()), this.thumbnailManager.toThumbnailedImage(item.thumbnail()), canDelete));
        }
        return builder.asList();
    }

    private boolean shouldExpandAsZip(Issue issue, Attachment attachment) {
        if (attachment.isZip() != null) {
            return attachment.isZip();
        }
        String mimetype = attachment.getMimetype();
        boolean isZip = false;
        if (mimetype.startsWith("application")) {
            String attachmentExtension = FilenameUtils.getExtension((String)attachment.getFilename());
            if (this.nonZipExpandableExtensions.contains(attachmentExtension) || WELL_KNOWN_MIMETYPES.contains(mimetype)) {
                isZip = false;
            } else {
                File attachmentFile = AttachmentUtils.getAttachmentFile((Issue)issue, (Attachment)attachment);
                isZip = this.attachmentZipKit.isZip(attachmentFile);
            }
        }
        this.attachmentManager.setZip(attachment, isZip);
        return isZip;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        Issue issue = (Issue)context.get("issue");
        ApplicationUser user = this.authenticationContext.getUser();
        return issue.getId() + "/" + (user == null ? "" : user.getName());
    }

    private static HttpServletRequest getRequest(Map<String, Object> context) {
        return ((JiraHelper)context.get("helper")).getRequest();
    }

    static {
        WELL_KNOWN_MIMETYPES.add("application/pdf");
        WELL_KNOWN_MIMETYPES.add("application/msword");
    }

    public class IconGenerator {
        public SimpleIcon getIcon(SimpleAttachment attachment) {
            FileIconBean.FileIcon fileIcon = AttachmentBlockContextProvider.this.fileIconUtil.getFileIcon(attachment.getFilename(), attachment.getMimetype());
            return new SimpleIcon(fileIcon == null ? "file.gif" : fileIcon.getIcon(), fileIcon == null ? "File" : fileIcon.getAltText());
        }

        public SimpleIcon getIcon(AttachmentZipKit.AttachmentZipEntry zipEntry) {
            FileIconBean.FileIcon fileIcon = AttachmentBlockContextProvider.this.fileIconUtil.getFileIcon(zipEntry.getName(), null);
            return new SimpleIcon(fileIcon == null ? "file.gif" : fileIcon.getIcon(), fileIcon == null ? "File" : fileIcon.getAltText());
        }

        public class SimpleIcon {
            private final String icon;
            private final String altText;

            public SimpleIcon(String icon, String altText) {
                this.icon = icon;
                this.altText = altText;
            }

            public String getIcon() {
                return this.icon;
            }

            public String getAltText() {
                return this.altText;
            }
        }
    }

    public class SimpleAttachment {
        private final Attachment attachment;
        private final boolean isLatest;
        private final boolean exapandAsZip;
        private final boolean psdImage;
        private final ThumbnailedImage thumbnail;
        private boolean canDelete;
        private AttachmentZipKit.AttachmentZipEntries attachmentZipEntries;

        public SimpleAttachment(Attachment attachment, boolean latest, boolean exapandAsZip, boolean psdImage, ThumbnailedImage thumbnail, boolean canDelete) {
            this.attachment = attachment;
            this.isLatest = latest;
            this.exapandAsZip = exapandAsZip;
            this.psdImage = psdImage;
            this.thumbnail = thumbnail;
            this.canDelete = canDelete;
        }

        public boolean isLatest() {
            return this.isLatest;
        }

        public Long getId() {
            return this.attachment.getId();
        }

        public String getMimetype() {
            return MimetypesFileTypeMap.getContentType((String)this.getFilename());
        }

        public String getFilename() {
            return this.attachment.getFilename();
        }

        public String getFilenameUrlEncoded() {
            return JiraUrlCodec.encode((String)this.attachment.getFilename(), (boolean)true);
        }

        public String getFileNameUrlEncodedPsdReplacedWithPng() {
            return JiraUrlCodec.encode((String)this.attachment.getFilename().replaceAll("\\.psd$", ".png"), (boolean)true);
        }

        public String getCreatedFormatted() {
            return AttachmentBlockContextProvider.this.dateTimeFormatter.format((Date)this.attachment.getCreated());
        }

        public String getCreatedIso8601() {
            return AttachmentBlockContextProvider.this.dateTimeFormatter.withStyle(DateTimeStyle.ISO_8601_DATE_TIME).format((Date)this.attachment.getCreated());
        }

        public String getFilesize() {
            return FileSize.format((Long)this.attachment.getFilesize());
        }

        public String getAuthor() {
            return this.attachment.getAuthorKey();
        }

        public String getDisplayAuthor() {
            ApplicationUser user = AttachmentBlockContextProvider.this.userManager.getUserByKeyEvenWhenUnknown(this.attachment.getAuthorKey());
            return user != null ? user.getDisplayName() : null;
        }

        public boolean isExpandAsZip() {
            return this.exapandAsZip;
        }

        public boolean isPsdImage() {
            return this.psdImage;
        }

        public ThumbnailedImage getThumbnail() {
            return this.thumbnail;
        }

        public boolean isCanDelete() {
            return this.canDelete;
        }

        public AttachmentZipKit.AttachmentZipEntries getZipEntries() {
            if (this.attachmentZipEntries == null) {
                try {
                    File attachmentFile = AttachmentUtils.getAttachmentFile((Attachment)this.attachment);
                    this.attachmentZipEntries = AttachmentBlockContextProvider.this.attachmentZipKit.listEntries(attachmentFile, AttachmentBlockContextProvider.this.helper.getMaximumNumberOfZipEntriesToShow(), AttachmentZipKit.FileCriteria.ONLY_FILES);
                    return this.attachmentZipEntries;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.attachmentZipEntries;
        }
    }
}

