/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview.viewissue;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import org.apache.commons.lang.StringUtils;

public class AttachmentBlockContextHelper {
    static final String ORDER_DESC = "desc";
    static final String DEFAULT_ISSUE_ATTACHMENTS_ORDER = "asc";
    static final String SORTBY_DATE_TIME = "dateTime";
    static final String DEFAULT_ISSUE_ATTACHMENTS_SORTBY = "fileName";
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final ApplicationProperties applicationProperties;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;

    AttachmentBlockContextHelper(VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, IssueManager issueManager, PermissionManager permissionManager) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.applicationProperties = applicationProperties;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
    }

    String getAttachmentOrder() {
        return this.getSessionBackedRequestParam("attachmentOrder", DEFAULT_ISSUE_ATTACHMENTS_ORDER, "jira.issue.attachment.order");
    }

    String getAttachmentSortBy() {
        return this.getSessionBackedRequestParam("attachmentSortBy", DEFAULT_ISSUE_ATTACHMENTS_SORTBY, "jira.issue.attachment.sortby");
    }

    private String getSessionBackedRequestParam(String requestParamName, String defaultValue, String sessionKey) {
        VelocityRequestContext requestContext = this.velocityRequestContextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        String requestParameter = requestContext.getRequestParameter(requestParamName);
        if (StringUtils.isNotBlank((String)requestParameter)) {
            if (requestParameter.equals(defaultValue)) {
                session.removeAttribute(sessionKey);
                return defaultValue;
            }
            session.setAttribute(sessionKey, (Object)requestParameter);
            return requestParameter;
        }
        String sortOrder = (String)session.getAttribute(sessionKey);
        return StringUtils.isNotBlank((String)sortOrder) ? sortOrder : defaultValue;
    }

    boolean getZipSupport() {
        return this.applicationProperties.getOption("jira.attachment.allow.zip.support");
    }

    int getMaximumNumberOfZipEntriesToShow() {
        String maximumNumberOfZipEntriesToShowAsString = this.applicationProperties.getDefaultBackedString("jira.attachment.number.of.zip.entries");
        int maximumNumberOfZipEntriesToShow = 30;
        try {
            maximumNumberOfZipEntriesToShow = Integer.parseInt(maximumNumberOfZipEntriesToShowAsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maximumNumberOfZipEntriesToShow;
    }

    boolean canDeleteAttachment(Issue issue, Attachment attachment, ApplicationUser user) {
        return this.issueManager.isEditable(issue) && (this.permissionManager.hasPermission(38, issue, user) || this.permissionManager.hasPermission(39, issue, user) && this.isUserAttachmentAuthor(attachment, user));
    }

    private boolean isUserAttachmentAuthor(Attachment attachment, ApplicationUser user) {
        ApplicationUser attachmentAuthor = attachment.getAuthorObject();
        if (attachmentAuthor == null && user == null) {
            return true;
        }
        if (attachmentAuthor == null || user == null) {
            return false;
        }
        return attachmentAuthor.equals((Object)user);
    }
}

