/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview.action;

import com.almworks.jira.psdpreview.LicenseManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.webresource.WebResourceManager;

@SupportedMethods(value={RequestMethod.GET})
public class PsdAttachmentsConfiguration
extends JiraWebActionSupport {
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final WebResourceManager webResourceManager;
    private final LicenseManager licenseManager;
    private final ApplicationProperties applicationProperties;
    private ModesState modeStates;

    public PsdAttachmentsConfiguration(PluginAccessor pluginAccessor, PluginController pluginController, WebResourceManager webResourceManager, LicenseManager licenseManager, ApplicationProperties applicationProperties) {
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
        this.webResourceManager = webResourceManager;
        this.licenseManager = licenseManager;
        this.applicationProperties = applicationProperties;
    }

    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @RequiresXsrfCheck
    public String doReplace() throws Exception {
        this.applicationProperties.setString("com.almworks.jira.psd-preview.mode", "replace");
        this.pluginController.enablePluginModule("com.almworks.jira.psd-preview:attachmentmodule");
        this.pluginController.disablePluginModule("com.almworks.jira.psd-preview:psd-attachmentmodule");
        this.pluginController.disablePluginModule("com.atlassian.jira.jira-view-issue-plugin:attachmentmodule");
        return this.getRedirect("/secure/admin/PsdAttachmentsConfiguration!default.jspa");
    }

    @RequiresXsrfCheck
    public String doSeparate() throws Exception {
        this.applicationProperties.setString("com.almworks.jira.psd-preview.mode", "separate");
        this.pluginController.enablePluginModule("com.almworks.jira.psd-preview:psd-attachmentmodule");
        this.pluginController.enablePluginModule("com.atlassian.jira.jira-view-issue-plugin:attachmentmodule");
        this.pluginController.disablePluginModule("com.almworks.jira.psd-preview:attachmentmodule");
        return this.getRedirect("/secure/admin/PsdAttachmentsConfiguration!default.jspa");
    }

    public boolean isLicenseExpired() {
        return this.licenseManager.isLicenseExpired();
    }

    public String expirationDate() {
        return this.getDateTimeFormatter().withStyle(DateTimeStyle.DATE).format(this.licenseManager.expirationDate());
    }

    public ModesState getModeStates() {
        if (this.modeStates == null) {
            this.modeStates = new ModesState(this.pluginAccessor);
        }
        return this.modeStates;
    }

    public boolean isReplaceModeActive() {
        return this.getModeStates().isReplaceModeActive();
    }

    public boolean isSeparateModeActive() {
        return this.getModeStates().isSeparateModeActive();
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    private class ModesState {
        private final boolean systemPanelEnabled;
        private final boolean replacePanelEnabled;
        private final boolean separatePanelEnabled;

        public ModesState(PluginAccessor pluginAccessor) {
            this.systemPanelEnabled = pluginAccessor.isPluginModuleEnabled("com.atlassian.jira.jira-view-issue-plugin:attachmentmodule");
            this.replacePanelEnabled = pluginAccessor.isPluginModuleEnabled("com.almworks.jira.psd-preview:attachmentmodule");
            this.separatePanelEnabled = pluginAccessor.isPluginModuleEnabled("com.almworks.jira.psd-preview:psd-attachmentmodule");
        }

        public boolean isReplaceModeActive() {
            return this.replacePanelEnabled && !this.systemPanelEnabled && !this.separatePanelEnabled;
        }

        public boolean isSeparateModeActive() {
            return this.separatePanelEnabled && this.systemPanelEnabled && !this.replacePanelEnabled;
        }
    }
}

