/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview;

import com.almworks.jira.psdpreview.PsdImage;
import com.almworks.jira.psdpreview.PsdThumbnailCreator;
import com.atlassian.core.util.thumbnail.Thumber;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.core.util.thumbnail.ThumbnailDimension;
import com.atlassian.jira.config.util.ThumbnailConfiguration;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.thumbnail.BrokenThumbnail;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.Supplier;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import psd.parser.ColorMode;
import psd.parser.PsdInputStream;
import psd.parser.header.HeaderSectionParser;

public class PsdThumbnailCreatorImpl
implements PsdThumbnailCreator {
    private static final Set<ColorMode> SUPPORTED_MODES = new HashSet<ColorMode>(Arrays.asList(ColorMode.RGB, ColorMode.GRAYSCALE));
    private final ThumbnailConfiguration thumbnailConfiguration;
    private final Function<Long, ManagedLock.ReadWrite> lockFactory = ManagedLocks.weakReadWriteManagedLockFactory();

    public PsdThumbnailCreatorImpl(ThumbnailConfiguration thumbnailConfiguration) {
        this.thumbnailConfiguration = thumbnailConfiguration;
    }

    @Override
    public Thumbnail createPsdThumbnailIfMissed(final Attachment attachment) {
        return (Thumbnail)((ManagedLock.ReadWrite)this.lockFactory.get((Object)attachment.getId())).write().withLock((Supplier)new Supplier<Thumbnail>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive exception aggregation
             */
            public Thumbnail get() {
                File attachmentFile = AttachmentUtils.getAttachmentFile((Attachment)attachment);
                File thumbnailFile = AttachmentUtils.getThumbnailFile((Attachment)attachment);
                try {
                    if (!thumbnailFile.exists()) {
                        InputStream inputStream = null;
                        try {
                            inputStream = new BufferedInputStream(new FileInputStream(attachmentFile));
                            PsdImage psd = new PsdImage(inputStream);
                            ThumbnailDimension psdDimensions = PsdThumbnailCreatorImpl.this.imageDimensions(psd);
                            FileUtils.touch((File)thumbnailFile);
                            FileUtils.deleteQuietly((File)thumbnailFile);
                            int maxWidth = PsdThumbnailCreatorImpl.this.thumbnailConfiguration.getMaxWidth();
                            int maxHeight = PsdThumbnailCreatorImpl.this.thumbnailConfiguration.getMaxHeight();
                            Thumber thumber = PsdThumbnailCreatorImpl.this.getThumber();
                            ThumbnailDimension helper = thumber.determineScaleSize(maxWidth, maxHeight, psdDimensions.getWidth(), psdDimensions.getHeight());
                            BufferedImage bufferedImage = thumber.scaleImage((Image)psd.getImage(), helper);
                            ImageIO.write((RenderedImage)bufferedImage, "png", thumbnailFile);
                            Thumbnail thumbnail = new Thumbnail(helper.getHeight(), helper.getWidth(), thumbnailFile.getName(), attachment.getId().longValue(), Thumbnail.MimeType.PNG);
                            return thumbnail;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    BufferedImage read = ImageIO.read(thumbnailFile);
                    return new Thumbnail(read.getHeight(), read.getWidth(), thumbnailFile.getName(), attachment.getId().longValue(), Thumbnail.MimeType.PNG);
                }
                catch (Exception e) {
                    try {
                        return new BrokenThumbnail(attachment.getId().longValue());
                    }
                    catch (Exception e2) {
                        return new BrokenThumbnail(attachment.getId().longValue());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isPsdFileAndSupported(Attachment attachment) {
        if (!attachment.getFilename().toLowerCase().endsWith(".psd")) return false;
        try {
            File attachmentFile = AttachmentUtils.getAttachmentFile((Attachment)attachment);
            InputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(attachmentFile));
                PsdInputStream stream = new PsdInputStream(inputStream);
                stream.mark(4);
                if (stream.readString(4).equals("8BPS")) {
                    stream.reset();
                    HeaderSectionParser parser = new HeaderSectionParser();
                    parser.parse(stream);
                    boolean bl2 = SUPPORTED_MODES.contains(parser.getHeader().getColorMode());
                    return bl2;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception e) {
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    private ThumbnailDimension imageDimensions(PsdImage psd) throws IOException {
        return new ThumbnailDimension(psd.getWidth(), psd.getHeight());
    }

    private Thumber getThumber() {
        return new Thumber(Thumbnail.MimeType.PNG);
    }
}

