/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import psd.parser.ColorMode;
import psd.parser.PsdFileParser;
import psd.parser.header.Header;
import psd.parser.header.HeaderSectionHandler;
import psd.parser.imagedata.ImageDataSectionHandler;
import psd.util.BufferedImageBuilder;

public class PsdImage {
    private Header header;
    private final BufferedImage image;

    public PsdImage(InputStream inputStream) throws IOException {
        final byte[][] channels = new byte[3][];
        PsdFileParser parser = new PsdFileParser();
        parser.getHeaderSectionParser().setHandler(new HeaderSectionHandler(){

            public void headerLoaded(Header header) {
                PsdImage.this.header = header;
            }
        });
        parser.getImageDataSectionParser().setHandler(new ImageDataSectionHandler(){

            public void channelLoaded(int channelId, byte[] channelData) {
                if (channelId >= 0 && channelId < 3) {
                    channels[channelId] = channelData;
                }
            }
        });
        parser.parse(inputStream);
        if (parser.getHeaderSectionParser().getHeader().getColorMode() == ColorMode.GRAYSCALE) {
            channels[1] = channels[2] = channels[0];
        }
        this.image = new BufferedImageBuilder((byte[][])channels, this.header.getWidth(), this.header.getHeight()).makeImage();
    }

    public int getWidth() {
        return this.header.getWidth();
    }

    public int getHeight() {
        return this.header.getHeight();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public ColorMode getColorMode() {
        return this.header.getColorMode();
    }
}

