/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview;

import com.almworks.jira.psdpreview.PsdThumbnailCreatorImpl;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.io.InputStreamConsumer;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericEntityException;

public class PsdAwareThumbnailManager
implements ThumbnailManager {
    private final ThumbnailManager delegate;
    private final PsdThumbnailCreatorImpl psdThumbnailCreator;

    public PsdAwareThumbnailManager(ThumbnailManager delegate, PsdThumbnailCreatorImpl psdThumbnailCreator) {
        this.delegate = delegate;
        this.psdThumbnailCreator = psdThumbnailCreator;
    }

    public Collection<Thumbnail> getThumbnails(Issue issue, ApplicationUser user) throws Exception {
        return this.delegate.getThumbnails(issue, user);
    }

    public boolean isThumbnailable(Attachment attachmentGV) throws GenericEntityException {
        return this.isThumbnailable(attachmentGV.getIssueObject(), attachmentGV);
    }

    public boolean isThumbnailable(Issue issue, Attachment attachmentGV) throws GenericEntityException {
        return this.delegate.isThumbnailable(issue, attachmentGV);
    }

    @Nullable
    public Thumbnail getThumbnailDeferred(Issue issue, Attachment attachment) {
        return this.getThumbnail(issue, attachment);
    }

    public boolean checkToolkit() {
        return this.delegate.checkToolkit();
    }

    @Nullable
    public Thumbnail getThumbnail(Attachment attachment) {
        return this.getThumbnail(attachment.getIssueObject(), attachment);
    }

    public Thumbnail getThumbnail(Issue issue, Attachment attachment) {
        if (this.psdThumbnailCreator.isPsdFileAndSupported(attachment)) {
            return this.psdThumbnailCreator.createPsdThumbnailIfMissed(attachment);
        }
        return this.delegate.getThumbnail(issue, attachment);
    }

    @Nullable
    public ThumbnailedImage toThumbnailedImage(@Nullable Thumbnail thumbnail) {
        return this.delegate.toThumbnailedImage(thumbnail);
    }

    public <T> T streamThumbnailContent(Attachment attachment, InputStreamConsumer<T> consumer) throws IOException {
        return (T)this.delegate.streamThumbnailContent(attachment, consumer);
    }

    public void deleteThumbnailForAttachment(@Nullable Issue issue, Attachment attachment) {
        this.delegate.deleteThumbnailForAttachment(issue, attachment);
    }

    public void deleteThumbnailsForIssue(Issue issue) {
        this.delegate.deleteThumbnailsForIssue(issue);
    }
}

