/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview;

import com.almworks.jira.psdpreview.PsdImage;
import com.almworks.jira.psdpreview.PsdThumbnailCreator;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import com.atlassian.jira.web.servlet.InvalidAttachmentPathException;
import com.atlassian.jira.web.servlet.MimeSniffingKit;
import com.atlassian.seraph.util.RedirectUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class PreviewServlet
extends HttpServlet {
    private final AttachmentManager attachmentManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final MimeSniffingKit mimeSniffingKit;
    private final PsdThumbnailCreator psdThumbnailCreator;

    public PreviewServlet(AttachmentManager attachmentManager, JiraAuthenticationContext jiraAuthenticationContext, PermissionManager permissionManager, PsdThumbnailCreator psdThumbnailCreator) {
        this.attachmentManager = attachmentManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.mimeSniffingKit = (MimeSniffingKit)ComponentAccessor.getComponent(MimeSniffingKit.class);
        this.psdThumbnailCreator = psdThumbnailCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File attachmentFile;
        Attachment attachment;
        try {
            attachment = this.getAttachment(this.attachmentPath(request));
            attachmentFile = this.getAttachmentFile(attachment);
        }
        catch (InvalidAttachmentPathException e) {
            response.sendError(400, "Invalid attachment path");
            return;
        }
        catch (AttachmentNotFoundException nfe) {
            this.send404(request, response);
            return;
        }
        catch (PermissionException e) {
            this.redirectForSecurityBreach(request, response);
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        if (this.psdThumbnailCreator.isPsdFileAndSupported(attachment)) {
            InputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(attachmentFile));
                BufferedImage original = new PsdImage(in).getImage();
                ByteArrayOutputStream temporaryStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)original, "png", temporaryStream);
                BufferedInputStream resultStream = new BufferedInputStream(new ByteArrayInputStream(temporaryStream.toByteArray()));
                String pngMimeType = Thumbnail.MimeType.PNG.toString();
                response.setContentType(pngMimeType);
                this.mimeSniffingKit.setAttachmentResponseHeaders(attachmentFile.getName(), pngMimeType, response);
                IOUtils.copy((InputStream)resultStream, (OutputStream)out);
                out.flush();
            }
            catch (FileNotFoundException e) {
                this.send404(request, response);
            }
            catch (IOException e) {
            }
            finally {
                if (in != null) {
                    in.close();
                }
                out.close();
            }
        } else {
            FileInputStream in;
            response.setContentType(attachment.getMimetype());
            response.setContentLength(attachment.getFilesize().intValue());
            try {
                in = new FileInputStream(attachmentFile);
            }
            catch (FileNotFoundException e) {
                this.send404(request, response);
                return;
            }
            try {
                response.setContentType(attachment.getMimetype());
                response.setContentLength(attachment.getFilesize().intValue());
                this.mimeSniffingKit.setAttachmentResponseHeaders(attachment.getFilename(), attachment.getMimetype(), response);
                HttpResponseHeaders.cachePrivatelyForAboutOneYear((HttpServletResponse)response);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                out.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                ((InputStream)in).close();
                out.close();
            }
        }
    }

    private void send404(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404, String.format("Attachment %s was not found", request.getPathInfo()));
    }

    private void redirectForSecurityBreach(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getUser() != null) {
            RequestDispatcher rd = request.getRequestDispatcher("/secure/views/securitybreach.jsp");
            JiraHttpUtils.setNoCacheHeaders((HttpServletResponse)response);
            rd.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
    }

    protected File getAttachmentFile(Attachment attachment) throws DataAccessException, PermissionException {
        if (!this.hasPermissionToViewAttachment(this.getUser(), attachment)) {
            throw new PermissionException("You do not have permissions to view this issue");
        }
        return AttachmentUtils.getAttachmentFile((Attachment)attachment);
    }

    protected Attachment getAttachment(String query) {
        long id;
        int x = query.indexOf(47, 1);
        String idStr = query.substring(1, x);
        try {
            id = Long.parseLong(idStr);
        }
        catch (NumberFormatException e) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        if (query.indexOf(47, x + 1) != -1) {
            throw new AttachmentNotFoundException((Object)idStr);
        }
        return this.attachmentManager.getAttachment(Long.valueOf(id));
    }

    protected final String attachmentPath(HttpServletRequest request) {
        String pi = request.getPathInfo();
        if (pi == null || pi.length() == 1 || pi.indexOf(47, 1) == -1) {
            throw new InvalidAttachmentPathException();
        }
        return pi;
    }

    protected final ApplicationUser getUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    protected boolean hasPermissionToViewAttachment(ApplicationUser user, Attachment attachment) throws DataAccessException {
        Issue issue = attachment.getIssueObject();
        return this.permissionManager.hasPermission(ProjectPermissions.BROWSE_PROJECTS, issue, user);
    }
}

