/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.psdpreview;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;

public class PanelStateListener {
    private final ApplicationProperties applicationProperties;
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final PluginEventManager pluginEventManager;

    public PanelStateListener(ApplicationProperties applicationProperties, PluginAccessor pluginAccessor, PluginController pluginController, PluginEventManager pluginEventManager) {
        this.applicationProperties = applicationProperties;
        this.pluginAccessor = pluginAccessor;
        this.pluginController = pluginController;
        this.pluginEventManager = pluginEventManager;
        pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        if (this.isEventRelated(event)) {
            boolean systemPanelEnabled = this.pluginAccessor.isPluginModuleEnabled("com.atlassian.jira.jira-view-issue-plugin:attachmentmodule");
            boolean replacePanelEnabled = this.pluginAccessor.isPluginModuleEnabled("com.almworks.jira.psd-preview:attachmentmodule");
            boolean separatePanelEnabled = this.pluginAccessor.isPluginModuleEnabled("com.almworks.jira.psd-preview:psd-attachmentmodule");
            if (!systemPanelEnabled) {
                this.pluginController.enablePluginModule("com.atlassian.jira.jira-view-issue-plugin:attachmentmodule");
            }
            if (replacePanelEnabled) {
                this.pluginController.disablePluginModule("com.almworks.jira.psd-preview:attachmentmodule");
            }
            if (separatePanelEnabled) {
                this.pluginController.disablePluginModule("com.almworks.jira.psd-preview:psd-attachmentmodule");
            }
            this.pluginEventManager.unregister((Object)this);
        }
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (this.isEventRelated(event)) {
            boolean systemPanelEnabled = this.pluginAccessor.isPluginModuleEnabled("com.atlassian.jira.jira-view-issue-plugin:attachmentmodule");
            boolean replacePanelEnabled = this.pluginAccessor.isPluginModuleEnabled("com.almworks.jira.psd-preview:attachmentmodule");
            boolean separatePanelEnabled = this.pluginAccessor.isPluginModuleEnabled("com.almworks.jira.psd-preview:psd-attachmentmodule");
            String mode = this.getMode();
            if ("replace".equals(mode)) {
                if (systemPanelEnabled) {
                    this.pluginController.disablePluginModule("com.atlassian.jira.jira-view-issue-plugin:attachmentmodule");
                }
                if (!replacePanelEnabled) {
                    this.pluginController.enablePluginModule("com.almworks.jira.psd-preview:attachmentmodule");
                }
                if (separatePanelEnabled) {
                    this.pluginController.disablePluginModule("com.almworks.jira.psd-preview:psd-attachmentmodule");
                }
            } else if ("separate".equals(mode)) {
                if (!systemPanelEnabled) {
                    this.pluginController.enablePluginModule("com.atlassian.jira.jira-view-issue-plugin:attachmentmodule");
                }
                if (replacePanelEnabled) {
                    this.pluginController.disablePluginModule("com.almworks.jira.psd-preview:attachmentmodule");
                }
                if (!separatePanelEnabled) {
                    this.pluginController.enablePluginModule("com.almworks.jira.psd-preview:psd-attachmentmodule");
                }
            }
        }
    }

    private String getMode() {
        String mode = this.applicationProperties.getString("com.almworks.jira.psd-preview.mode");
        if (mode == null || "".equals(mode)) {
            this.applicationProperties.setString("com.almworks.jira.psd-preview.mode", "replace");
            mode = "replace";
        }
        return mode;
    }

    private boolean isEventRelated(PluginDisabledEvent event) {
        String key = event.getPlugin().getKey();
        return "com.almworks.jira.psd-preview".equals(key);
    }

    private boolean isEventRelated(PluginEnabledEvent event) {
        String key = event.getPlugin().getKey();
        return "com.almworks.jira.psd-preview".equals(key);
    }
}

