define("addonrock/download-attachments/bootstrap-srv", [
		"addonrock/download-attachments/resources",
		"addonrock/download-attachments/export-to-zip",
		"jquery"
	], function (resources, exportToZip, $) {
		var dialogContainerId = "download-attachments-dialog-container";
		var dialogContainerSelector = "#" + dialogContainerId;
		var dialogSelector = "#download-attachments-export-to-zip-dialog";
		var exportQueryLinkSelector = "a.aui-list-item-link[href*=addonrock-srv-download-attachments]";
		var exportIssueLinkSelector = "a[href*=addonrock-download-attachments-export-issue]";
		var clickInProgress = false;

		function prepareAndShowDialog(e, query) {
			e.preventDefault();
			var $body = $("body");
			AJS.log("[Download Attachments] On click registered");
			if (clickInProgress) {
				return;
			}
			clickInProgress = true;
			var $dialogContainer = $(dialogContainerSelector)
			if ($dialogContainer.length) {
				AJS.log("[Download Attachments] Remove old dialog instance");
				$dialogContainer.remove();
			}

			$body.append("<div id='" + dialogContainerId + "'></div>");
			$dialogContainer = $body.find(dialogContainerSelector);
			$dialogContainer.load(resources.exportToZip.template, function () {
				exportToZip.init(dialogSelector, query);
				clickInProgress = false;
			});
		}

		$(function () {
			AJS.log("[Download Attachments] Bootstrapping download attachment link, JQuery version:", $.fn.jquery);
			var $body = $("body");
			$body.on("click", exportQueryLinkSelector, function (e) {
				var jql = AJS.Meta.get("filter-jql");
				var filterId = AJS.Meta.get("filter-id");
				var query = '';
				if (filterId !== undefined && filterId !== null && filterId > 0) {
					query = "filter=" + filterId;
				} else if (jql !== undefined && jql !== null) {
					query = jql;
				}
				prepareAndShowDialog(e, query);
			});
			JIRA.bind(JIRA.Events.NEW_CONTENT_ADDED, function (e, context, reason) {
				var link = $(context).find(exportIssueLinkSelector);
				//AJS.log("[Download attachments] Bootstrapping export attachments to ZIP for Issue, context :", context);
				//AJS.log("[Download attachments] Link :", link);
				if (link) {
					link.click(function (e) {
						var issueKey = AJS.Meta.get("issue-key");
						prepareAndShowDialog(e, "key=" + issueKey);
					});
				}
			});
		});
	}
);

require("addonrock/download-attachments/bootstrap-srv");