define("addonrock/download-attachments/export-to-zip", [
	"aui/dialog2",
	"addonrock/download-attachments/Vue",
	"addonrock/download-attachments/export-to-zip-config",
	"addonrock/download-attachments/export-to-zip-download",
	"addonrock/download-attachments/export-to-zip-search",
	"addonrock/download-attachments/license-service",
	"jquery"
], function (dialog2, Vue, configFactory, DownloadService, SearchService, LicenseService, $) {
	var exportToZip = {};

	exportToZip.init = function (dialogSelector, jql) {
		AJS.log("[Download Attachments] Starting new dialog window with search params", jql);

		Vue.component('export-to-zip-section', {
			props: ['info', 'ruleSets', 'possibleRules'],
			model: {
				prop: 'ruleSets',
				event: 'update'
			},
			data: function () {
				var ruleToAdd = [];
				this.ruleSets.forEach(function () {
					ruleToAdd.push("");
				});

				return {
					isEditMode: false,
					ruleToAdd: ruleToAdd
				}
			},
			methods: {
				removeRule: function (ruleSetIndex, ruleId) {
					//AJS.log("Trying to remove rule: ", ruleSetIndex, ruleId);
					var rules = this.ruleSets[ruleSetIndex].rules;
					for (var i = 0; i < rules.length; i++) {
						var rule = rules[i];
						if (rule.id === ruleId) {
							rules.splice(i, 1);
							this.$emit('update', this.ruleSets);
							return;
						}
					}
				},
				addSelectedRule: function (ruleSetIndex) {
					var ruleToAdd = this.ruleToAdd[ruleSetIndex];
					//AJS.log("Trying to add rule: ", ruleSetIndex, ruleToAdd);
					if (ruleToAdd !== undefined && ruleToAdd !== "") {
						var ruleInstance = ruleToAdd.createInstance();
						//AJS.log("New rule instance created", ruleInstance);
						this.ruleSets[ruleSetIndex].rules.push(ruleInstance);
						//AJS.log("Rule list: ", this.ruleSets[ruleSetIndex].rules);
						this.$emit('update', this.ruleSets);
					}
				}
			},
			template: '#download-attachments-export-to-zip-section'
		});

		Vue.component('export-to-zip-rule', {
			props: ['rule', 'removable', 'color'],
			template: '#download-attachments-export-to-zip-rule'
		});

		Vue.component('export-to-zip-rule-add', {
			template: '#download-attachments-export-to-zip-rule-add'
		});

		Vue.component('export-to-zip-rule-add-static', {
			template: '#download-attachments-export-to-zip-rule-static'
		});

		new Vue({
			el: dialogSelector,
			data: {
				message: "",
				isEditFilterRules: false,
				dictionaries: configFactory.getDictionaries(),
				operationsLog: "",
				licenseError: null,
				downloadError: false,
				downloadInProgress: false,
				totals: {
					issues: 0,
					attachmentsDownloaded: 0,
					attachmentsToInclude: 0,
					attachmentsAll: 0
				},
				sections: [
					{
						title: "Include / exclude attachments",
						description: "Configure what files should be included in result zip archive. You can " +
							"<span class=\"aui-lozenge aui-lozenge-success da-export-to-zip-rule\">include</span>" +
							" or " +
							"<span class=\"aui-lozenge aui-lozenge-error da-export-to-zip-rule\">exclude</span>" +
							" files based on name / extension, etc.",
						subtitle: "Rules: ",
						ruleSets: configFactory.createDefaultFilterRules(),
						dictionary: configFactory.getDictionaries()['filterRules']
					},
					{
						title: "Attachments grouping",
						description: "Change how files should be grouped into folders. For example you can group attachments by issue key: attachments will placed in folders named after issue keys.",
						subtitle: "Grouping:",
						ruleSets: configFactory.createDefaultGroupingRules(),
						dictionary: configFactory.getDictionaries()['grouping']
					}
					/*
					,
					{
						title: "Attachments renaming",
						description: "Enables and configures how attachments are renamed. For example you can set issue key prefix to each attachment name: <i>PROJ-54-document.doc</i>",
						subtitle: "Renaming:",
						ruleSets: configFactory.createDefaultGroupingRules(),
						dictionary: configFactory.getDictionaries()['grouping']
					},
					{
						title: "Split result",
						description: "If result ZIP file is to big and fails to download properly please try splitting it into multiple smaller zip files.",
						subtitle: "Splitting:",
						ruleSets: configFactory.createDefaultGroupingRules(),
						dictionary: configFactory.getDictionaries()['grouping']
					}
					*/
				]
			},
			mounted: function () {
				this.$nextTick(function () {
					AJS.log("[Download Attachments] Showing created dialog");
					setupAndShowDialog(dialogSelector);
				})
			},
			methods: {
				shouldIncludeCallback: function (issue, attachment) {
					//AJS.log("[Download Attachments] Running should include callback for", issue, attachment);
					var includeRules = this.sections[0].ruleSets[0].rules;
					//AJS.log("[Download Attachments] Rules", this.sections[0].ruleSets[0].rules, this.sections[0].ruleSets[1].rules);
					var shouldInclude = false;
					for (var i = 0; i < includeRules.length; i++) {
						shouldInclude = shouldInclude || includeRules[i].apply(issue, attachment);
						if (shouldInclude) break;
					}
					if (shouldInclude) {
						var excludeRules = this.sections[0].ruleSets[1].rules;
						for (var j = 0; j < excludeRules.length; j++) {
							if (excludeRules[j].apply(issue, attachment)) {
								shouldInclude = false;
								break;
							}
						}
					}
					return shouldInclude;
				},
				getFolderNameCallback: function (issue, attachment) {
					//AJS.log("[Download Attachments] Trying do discover folder for", issue, attachment);
					var groupingRules = this.sections[1].ruleSets[0].rules;
					//AJS.log("[Download Attachments] Grouping rules: ", groupingRules);
					var folderName = null;
					if (groupingRules.length > 0) {
						folderName = '';
						for (var i = 0; i < groupingRules.length; i++) {
							var subfolder = groupingRules[i].apply(issue, attachment).replace(/[^a-zA-Z0-9.\- ]/g, '');
							if (subfolder.length > 0) {
								folderName = folderName + subfolder + '/';
							}
						}
					}
					//AJS.log("[Download Attachment] Final folder name is ", folderName);
					return folderName;
				},
				searchErrorCallback: function (message) {
					this.operationsLog += message + '\n';
					var operationsLog = this.$refs.operationsLog;
					operationsLog.scrollTop = operationsLog.scrollHeight;
				},
				addMessageProgressCallback: function (message) {
					this.operationsLog += message + '\n';
					var operationsLog = this.$refs.operationsLog;
					operationsLog.scrollTop = 1000000000;
				},
				downloadProgressCallback: function (percent) {
					//AJS.log("Percent", percent);
					AJS.progressBars.update("#downloadAttachmentProgress", percent / 100);
				},
				validLicense: function (onValidLicense) {
					var thisRef = this;
					LicenseService.validate() //
						.fail(function (jqXHR, textStatus, errorThrown) {
							//AJS.log("aa", jqXHR, textStatus, errorThrown);
							var errorResponse = JSON.parse(jqXHR.responseText);
							if (errorResponse) {
								thisRef.licenseError = errorResponse.errorMessages.join("\n");
							} else {
								thisRef.licenseError = textStatus + "\n" + errorThrown
							}
						})
						.done(function () {
							onValidLicense();
						});
				},
				performDownload: function () {
					this.operationsLog = '';
					var thisRef = this;
					this.downloadInProgress = true;
					SearchService.findAttachments(jql, this.shouldIncludeCallback, this.addMessageProgressCallback, this.searchErrorCallback).then(function (value) {
						//AJS.log("Value", value);
						var ds = new DownloadService();
						thisRef.totals = value.totals;
						thisRef.totals.attachmentsDownloaded = 0;
						ds.addAttachments(value.attachments, thisRef.getFolderNameCallback, thisRef.addMessageProgressCallback, thisRef.downloadProgressCallback, function () {
							ds.download(function () {
								AJS.log("[Download Attachments] Download completed, errors: ", thisRef.downloadError);
								thisRef.downloadInProgress = false;
								thisRef.downloadError = ds.errorCounter > 0 || ds.zipppingError;
								}, thisRef.downloadProgressCallback, thisRef.addMessageProgressCallback);
						});
					});
				},
				startDownload: function () {
					this.licenseError = null;
					this.downloadError = false;
					this.validLicense(this.performDownload);
				}
			}
		});
	};

	function setupAndShowDialog(dialogSelector) {
		var dialog = dialog2(dialogSelector);
		dialog.show();
		$(dialogSelector).find("#download-attachments-dialog-close-button").click(function () {
			dialog.hide();
		});
		return dialog;
	}

	return exportToZip;
});