define("addonrock/download-attachments/export-to-zip-search", [
	"addonrock/download-attachments/resources",
	"jquery"
], function (resources, $) {

	var pageSize = 100;
	var fields = ['attachment', 'summary'];

	var SearchService = function () {
	};

	var AttachmentInfo = function (attachment, issue) {
		this.attachment = attachment;
		this.issue = issue;
	};

	function findIssuesWithPaging(jqlQuery, page, pageSize, fields) {
		return $.ajax({
			method: 'POST',
			type: "POST",
			url: resources.searchApiUrl,
			contentType: "application/json;charset=utf-8",
			data: JSON.stringify({
				startAt: page * pageSize,
				maxResults: pageSize,
				jql: jqlQuery,
				fields: fields,
				validateQuery: 'true'
			})
		}).promise();
	}

	SearchService.prototype.findAttachments = function (jqlQuery, shouldIncludeCallback, progressCallback, errorCallback) {
		AJS.log("[Download Attachments] JQuery version: ", $.fn.jquery);
		var resultPromise = $.Deferred();
		var totals = {
			issues: 0,
			attachmentsToInclude: 0,
			attachmentsAll: 0
		};
		var attachments = [];

		progressCallback("Trying to find issues & attachments for query: '" + jqlQuery + "', results will be paged, pageSize=" + pageSize, totals);
		getPage(0);

		function getPage(page) {
			var promise = findIssuesWithPaging(jqlQuery, page, pageSize, fields);
			promise.done(
				function (result, status) {
					AJS.log("[Download Attachments] searching for attachments info, jql=", jqlQuery, "page=", page, "status=", status);
					var shouldFetchNextPage = result.issues.length === pageSize;
					totals.issues += result.issues.length;
					result.issues.forEach(function (issue) {
						var attachmentsField = issue.fields.attachment;
						if (attachmentsField != null) {
							totals.attachmentsAll += attachmentsField.length;
							attachmentsField.forEach(function (attachment) {
								if (shouldIncludeCallback(issue, attachment)) {
									attachments.push(new AttachmentInfo(attachment, issue));
									totals.attachmentsToInclude += 1;
								}
							});
						}
					});
					progressCallback("Page " + page + " fetched, issues=" + totals.issues + ", attachments to include=" + totals.attachmentsToInclude +
						", attachments to exclude=" + (totals.attachmentsAll - totals.attachmentsToInclude));
					if (shouldFetchNextPage) {
						getPage(page + 1)
					} else {
						resultPromise.resolve({
							totals: totals,
							attachments: attachments
						})
					}
				});
			promise.fail(function (jqXHR, textStatus, errorThrown) {
				errorCallback(errorThrown);
				resultPromise.resolve({
					totals: totals,
					attachments: attachments
				})
			});
		}

		return resultPromise.promise();
	};

	return new SearchService();
});