define('tmatesoft/svnmirror/util/tree-dialog', [
    'jquery',
    '@atlassian/aui',
    'tmatesoft/svnmirror/util/json'
], function(
    $,
    AJS,
    json) {

    var dialog;

    var createDialog = function(id, template, jsTreeSettings, result) {
        var existingDialog = $(id);
        if (existingDialog.length > 0) {
            existingDialog.remove();
        }
        $(document.body).append(template);

        var dialog = AJS.dialog2(id);
        var initialSelection = false;

        var closeButton = $(id + '-close-button');
        var okButton = $(id + '-ok-button');
        var jstree = $(id + '-tree');
        var selectedPath = $(id + '-selected-path');

        closeButton.click(removeDialog);
        okButton.click(function() {
            removeDialog();
            result(selectedPath.text());
        });
        okButton.prop('disabled', true);

        jstree.jstree(jsTreeSettings)
            .delegate(".jstree-open>a", "click.jstree", function(event){
                $.jstree._reference(this).close_node(this,false,false);
            })
            .delegate(".jstree-closed>a", "click.jstree", function(event){
                $.jstree._reference(this).open_node(this,false,false);
            })
            .on('hover_node.jstree', function(e, data) {
                var node = $(data.args[0]);
                jstree.jstree('deselect_all');
                jstree.jstree('select_node', node);
            })
            .on('select_node.jstree', function(e, data) {
                var metadata = $(data.rslt.obj).data('type');
                if (metadata && metadata == 'folder') {
                    var node = $(data.args[0]);
                    okButton.prop('disabled', false);
                    okButton.focus();
                    var path = convertPath(jstree.jstree('get_path', node, false));
                    selectedPath.text(path);
                } else {
                    okButton.prop('disabled', true);
                    selectedPath.text('<none selected>');
                }
            })
            .on('before.jstree', function(e, data) {
                if (data.func === 'load_node_json') {
                    var nodeId = $(data.args[0]).attr('id');
                    $('#' + nodeId + ' > a > ins').removeClass('aui-icon aui-icon-small aui-iconfont-devtools-folder-closed');
                } else if (data.func === 'after_open' || data.func === 'correct_state') {
                    var nodeId = $(data.args[0]).attr('id');
                    $('#' + nodeId + ' > a > ins').addClass('aui-icon aui-icon-small aui-iconfont-devtools-folder-closed');
                }
            })
            .on('after_open.jstree', function(e, data) {
                if (!initialSelection) {
                    var found;
                    $('#tree-node-0 li').each(function(e) {
                        if (!found) {
                            found = $(this).attr('id');
                        }
                        var name = jstree.jstree('get_text', $(this));
                        if (name && name.toLowerCase() == 'trunk') {
                            found = $(this).attr('id');
                            return false;
                        }
                    });
                    if (!found) {
                        found = 'tree-node-0';
                    }
                    jstree.jstree('select_node', '#' + found);
                    initialSelection = true;
                }
            });
        jstree.off('mouseenter.jstree');
        jstree.off('mouseleave.jstree');

        jstree.keyup(function(event) {
            event.preventDefault();
            var code = event.keyCode || event.which;
            if (code == 13 && !$(id + '-ok-button').is(':disabled')) {
                okButton.click();
            }
            return false;
        });

        dialog.on('hide', removeDialog);
        dialog.on('show', function() {
            jstree.jstree('set_focus');
        });

        return dialog;
    };

    var removeDialog = function() {
        if (dialog != null) {
            dialog.hide();
            dialog = null;
        }
    };

    var convertPath = function(segments) {
        var path = '';
        for (var i = 1; segments != null && i < segments.length; i++) {
            path += segments[i];
            if (i < segments.length - 1) {
                path += '/';
            }
        }
        return path;
    };

    return {
        show : function(id, template, jsonUrl, state, result) {
            removeDialog();

            var lastId = 1;
            var jsTreeSettings = {
                core : {
                    initially_open : [ 'tree-node-0' ],
                    animation : 200
                },
                ui : {
                    select_limit : 1
                },
                json_data : {
                    data : {
                        attr : { id : 'tree-node-0' },
                        metadata : { type : 'root' },
                        data : {
                            title : state.data.url,
                            icon : 'aui-icon aui-icon-small aui-iconfont-repository-small repository-icon'
                        },
                        state : 'closed'
                    },
                    ajax : {
                        url : jsonUrl,
                        type: 'POST',
                        contentType: 'application/json; charset=utf-8',
                        data : function(node) {
                            var completeUrl = state.data.url;
                            var path = convertPath(this.get_path(node, false));
                            if (path && path != '') {
                                completeUrl = completeUrl + '/' + path;
                            }
                            var stateCopy = JSON.parse(JSON.stringify(state));
                            stateCopy.data.url = completeUrl;
                            return JSON.stringify(json.encode(stateCopy));
                        },
                        success : function(data) {
                            data = json.decode(data);
                            if (data && data.error) {
                                data.attr = { id : 'tree-node-' + lastId };
                                data.data = {
                                    title : data.error,
                                    icon : 'aui-icon aui-icon-small aui-iconfont-error tree-node-icon-error'
                                };
                                data.metadata = { type : 'error' };
                                lastId++;
                                data = [data];
                            } else if (data && data.length > 0) {
                                for(var i = 0; i < data.length; i++) {
                                    data[i].attr = { id : 'tree-node-' + lastId };
                                    data[i].state = 'closed';
                                    data[i].metadata = { type : 'folder' };
                                    data[i].data = {
                                        title : data[i].name,
                                        icon : 'aui-icon aui-icon-small aui-iconfont-folder-filled'
                                    };
                                    lastId++;
                                }
                            }
                            return data;
                        }
                    }
                },
                plugins : ['json_data', 'hotkeys', 'ui']
            };

            dialog = createDialog(id, template, jsTreeSettings, result);
            dialog.show();
        }
    };
});