define('tmatesoft/svnmirror/util/json', [
    'exports'
], function(
    exports) {

    exports.encode = function(obj) {
        if (!obj) {
            return null;
        }
        return JSON.parse(JSON.stringify(obj), function(k, v) {
            if (typeof v === 'string' || v instanceof String) {
                return encodeURIComponent(v);
            }
            return v;
        });
    };

    exports.decode = function(obj) {
        if (!obj) {
            return null;
        }
        return JSON.parse(JSON.stringify(obj), function(k, v) {
            if (typeof v === 'string' || v instanceof String) {
                return decodeURIComponent(v);
            }
            return v;
        });
    };

});