define('tmatesoft/svnmirror/util/form', [
    'jquery',
    'exports'
], function(
    $,
    exports) {

    var addBadge = function(selector) {
        selector.each(function() {
            var badgeId = $(this).attr('id') + '-badge';
            $(this).after('<span id="' + badgeId + '"></span>');
        });
    };

    var setUIValue = function(selector, value) {
        selector.each(function() {
            var tag = $(this).prop('tagName').toLowerCase();
            if (tag == 'span') {
                if ($(this).text() != value) {
                    $(this).text(value);
                }
            } else if (tag == 'textarea' || tag == 'select' || $(this).hasClass('text')) {
                if ($(this).val() != value) {
                    $(this).val(value);
                }
            } else if ($(this).hasClass('radio') || $(this).hasClass('checkbox')) {
                var checked = $(this).prop('checked');
                if (checked != value) {
                    $(this).prop('checked', value ? true : false);
                }
            }
        });
    };

    var updateBadge = function(selector, iconClass, tooltip) {
        selector.each(function() {
            var badgeId = '#' + $(this).attr('id') + '-badge';
            $(badgeId).attr('title', tooltip);
            $(badgeId).removeClass();
            $(badgeId).addClass('aui-icon aui-icon-small');
            if (iconClass) {
                $(badgeId).addClass(iconClass);
            }
        });
    };


    var trackFieldChanges = function(selector, cb) {
        selector.each(function() {
            var field = $(this);
            if (field.is(':checkbox') || field.is(':radio')) {
                field.change(function() {
                    if ($(this).is(':radio')) {
                        $('#' + $(this).attr('name') + ' input[type="radio"]').each(function() {
                            cb($(this), $(this).is(':checked'));
                        });
                    } else {
                        cb(field, $(this).is(':checked'));
                    }
                });
            } else {
                field.mouseup(function() {
                    var oldValue = $(this).val();
                    if (oldValue == '') {
                        return;
                    }
                    window.setTimeout(function() {
                        cb(field, field.val());
                    }, 1);
                });
                field.bind('change paste keyup', function() {
                    cb(field, $(this).val());
                });
            }
        });
    };

    var setEnabled = function(selector, enabled) {
        selector.each(function() {
            $(this).prop('disabled', !enabled);
        });
    };

    var selectAllOnFocus = function(selector) {
        selector.on('focus', function() {
            var field = $(this)
                .one('mouseup.mouseupSelect', function() {
                    field.select();
                    return false;
                })
                .one('mousedown', function() {
                    field.off('mouseup.mouseupSelect');
                })
                .select();
        });
    };

    var renderTemplate = function(target, template) {
        $(target).empty();
        $(target).removeClass();
        $(target).append(template);

        return $(target);
    };

    exports.addBadge = addBadge;
    exports.updateBadge = updateBadge;
    exports.setEnabled = setEnabled;
    exports.trackFieldChanges = trackFieldChanges;
    exports.selectAllOnFocus = selectAllOnFocus;
    exports.setUIValue = setUIValue;

    exports.renderTemplate = renderTemplate;
});