define('tmatesoft/svnmirror/util/error', [
    'jquery',
    '@atlassian/aui',
    'exports'
], function(
    $,
    AJS,
    exports) {
    
    var errorDialog = null;
    
    var showDialog = function(templateFactory, action) {
        if (errorDialog) {
            errorDialog.hide();
            errorDialog = null;
        }
        var template = templateFactory();

        $('body').append(template);
        var id = '#' + $(template).attr('id');
        errorDialog = AJS.dialog2(id);
        $(id + '-ok-button').click(action);
        errorDialog.show();
    };
    
    exports.dialog = function() {
        var templateFactory = null;
        var actionCb = null;
        
        var obj = {
            template : function(t) {
                templateFactory = t;
                return obj;
            },
            action : function(a) {
                actionCb = a;
                return obj;
            },
            show : function() {
                showDialog(templateFactory, actionCb);
                return obj;
            }            
        };
        return obj;
    };
});