define('tmatesoft/svnmirror/main', [
    '@atlassian/aui',
    'exports',
    'bitbucket/util/navbuilder',
    'tmatesoft/svnmirror/controller',
    'tmatesoft/svnmirror/aux',
    'tmatesoft/svnmirror/configure',
    'tmatesoft/svnmirror/install',
    'tmatesoft/svnmirror/status',
    'tmatesoft/svnmirror/credentials',
    'tmatesoft/svnmirror/util/error',
    'tmatesoft/svnmirror/util/poll',
    'tmatesoft/svnmirror/util/json'
], function(
    AJS,
    exports,
    nav,
    controller,
    aux,
    configure,
    install,
    statusBuilder,
    credentials,
    errorDialog,
    poller,
    json) {

    var showReloadDialog = function(message) {
        errorDialog
            .dialog()
            .template(function() {
                return svnmirror.errorDialog({errorMessage : message });
            })
            .action(function() {
                location.reload(true);
            })
            .show();
    };

    var buildCommandUrl = function(commandName, state) {
        return '?command=' + commandName;
    };

    exports.onReady = function(initialState, pollOptions) {

        AJS.$('.aui-page-panel-content').css('position', 'relative');

        var pollUrl = buildCommandUrl('poll', initialState);
        var p = poller.poll(pollUrl, pollOptions);
        var ctrl = controller.create('#svnmirror-status', '#svnmirror-form');

        var submittedTaskId = -1;
        var runningTaskId = -1;

        var command = function() {
            return function(name, data) {
                ctrl.update({
                    task : statusBuilder.sendingCommandStatus(name)
                });
                ctrl.disable();

                var commandUrl = buildCommandUrl(name, data);
                var postData = json.encode(data);
                if (name == 'cancel' && submittedTaskId > 0) {
                    postData.task.id = submittedTaskId;
                }

                AJS.$.ajax({
                    url: commandUrl,
                    type: 'POST',
                    data: JSON.stringify(postData),
                    contentType: 'application/json; charset=utf-8',
                    dataType: 'json',
                    success : function(data) {
                        if (!data || data.error) {
                            p.stop();
                            showReloadDialog(data ? data.error : 'unknown error');
                        } else {
                            submittedTaskId = name != 'cancel' ? data.taskId : -1;
                        }
                    },
                    error: function(xhr, status, error) {
                        p.stop();
                        showReloadDialog(xhr.responseText != null ? xhr.responseText : error);
                    }
                });
                window.setTimeout(p.now, 500);
            };
        };

        initialState.task = statusBuilder.retrievingStatus();

        var installView = install.view();
        var externalView = aux.externalView();
        var noLicenseView = aux.noLicenseView();
        var noLicenseCommand = function() {
            var targetUrl = nav.pluginServlets().path('upm').withFragment('manage/org.tmatesoft.subgit.stash-svn-importer').build();
            window.location.href = targetUrl;
        };

        ctrl
            .status(statusBuilder.view())
            .view('INITIAL', configure.view())
            .view('CONFIGURED', installView)
            .view('INSTALLED', installView)
            .view('PAUSED', installView)
            .view('EXTERNAL_LOCAL', externalView)
            .view('EXTERNAL_REMOTE', externalView)
            .view('NO_LICENSE', noLicenseView)
            .on('cancel', command())
            .on('stop', command())
            .on('start', command())
            .on('uninstall', command())
            .on('refresh', command())
            .on('testConnection', function(name, state) {
                credentials.testConnection(state);
            })
            .on('configure', command())
            .on('apply', command())
            .on('revert', function() {
                ctrl.revert();
            })
            .on('license', noLicenseCommand)
            .update(initialState);

        p.data(function(delta) {
            delta = json.decode(delta);
            if (delta.error) {
                p.stop();
                showReloadDialog(delta.error);
            } else {
                ctrl.update(delta);
                runningTaskId = ctrl.state.task.id;
                if (runningTaskId > submittedTaskId) {
                    submittedTaskId = -1;
                }
            }
        })
        .error(showReloadDialog)
        .poll();

        p.now();
    };
});