define('tmatesoft/svnmirror/status', [
    '@atlassian/aui',
    'exports',
    'tmatesoft/svnmirror/controller',
    'tmatesoft/svnmirror/util/form'
    ],
function(
    AJS,
    exports,
    controller,
    form) {

    var formatDate = function(time) {
        var date = new Date(time);
        return date.getFullYear()
            + '-'
            + ('0' + (date.getMonth() + 1)).slice(-2)
            + '-'
            + ('0' + date.getDate()).slice(-2)
            + ' at '
            + ('0' + date.getHours()).slice(-2)
            + ':'
            + ('0' + date.getMinutes()).slice(-2)
            + ':'
            + ('0' + date.getSeconds()).slice(-2);
    };

    var retrievingStatus = function() {
        return {
            message : AJS.I18n.getText('svnmirror.settings.status.retrieving.message'),
            state : 'RUNNING',
            cancellable : false,
            percentage : 100,
            name : null
        };
    };

    var sendingCommandStatus = function(command) {
        return {
            message : AJS.I18n.getText('svnmirror.settings.status.sendingCommand.message', command),
            state : 'RUNNING',
            cancellable : false,
            percentage : 100,
            taskName : null
        };
    };

    var buildStatus = function(state) {
        var data = state.data || {};
        var status = state.task || {};

        var title = AJS.I18n.getText('svnmirror.settings.status.header');
        var message = status.message;
        var percentage = status.percentage || 0;
        var stage = data.stage;

        if (status.state == 'CANCELLING' || status.state == 'AUTO_CANCELLING') {
            message = AJS.I18n.getText('svnmirror.settings.status.cancelling.message', status.name);
        } else if (status.state == 'CANCELLED' && stage == 'INSTALLED') {
            message = AJS.I18n.getText('svnmirror.settings.status.cancelled.message', status.name);
        }

        if (!message) {
            if (stage == 'INITIAL') {
                message = AJS.I18n.getText('svnmirror.settings.status.initial.message');
            } else if (stage == 'CONFIGURED') {
                message = AJS.I18n.getText('svnmirror.settings.status.configured.message');
            } else if (stage == 'INSTALLED') {
                if (status.name == 'sync' && status.completed && status.state == 'SUCCESS') {
                    message = 'Last synced on ' + formatDate(status.completed);
                } else {
                    message = AJS.I18n.getText('svnmirror.settings.status.installed.message');
                }
            } else if (stage == 'PAUSED') {
                 message = AJS.I18n.getText('svnmirror.settings.status.paused.message');
            } else if (stage == 'PENDING_METADATA_MOVE') {
                 message = AJS.I18n.getText('svnmirror.settings.status.pendingMetadataMove.message');
            } else if (stage == 'EXTERNAL_REMOTE') {
                message = AJS.I18n.getText('svnmirror.settings.status.externalRemote.message');
            } else if (stage == 'EXTERNAL_LOCAL') {
                message = AJS.I18n.getText('svnmirror.settings.status.externalLocal.message');
            } else if (stage == 'NO_LICENSE') {
                message = AJS.I18n.getText('svnmirror.settings.status.noLicense.message');
            } else {
                message = '';
            }
        }

        var type = 'generic';
        if (status.state == 'FAILED' || status.state == 'FAILING' || stage == 'NO_LICENSE') {
            type = 'error';
        } else if (stage == 'INSTALLED' || stage == 'PAUSED') {
            if (data && data.unsyncedRefs) {
                if (data.unsyncedRefs.length > 0) {
                    type = 'warning';
                }
            }
        }

        var pendingMessage = null;
        var pendingTask = state.pending && state.pending.length > 0 ? state.pending[0] : null;
        if (status.percentage < 0 && pendingTask) {
            if (pendingTask.name == 'sync' && pendingTask.scheduled > 0) {
                var date = new Date(pendingTask.scheduled);
                var dateString = 'on ' + formatDate(pendingTask.scheduled);
                pendingMessage = 'next \'' + pendingTask.name + '\' ' + dateString;
            } else if (state.pendingTime <= 0) {
                pendingMessage = '\'' + pendingTask.name + '\' is pending'
            }
        }

        return {
            title : title,
            message : message,
            pendingMessage : pendingMessage,
            percentage : percentage,
            state : status.state,
            cancellable : status.cancellable || false,
            type : type
        };
    };

    exports.view = function() {
        var statusView = controller.view(function(state) {
            var dataStage = state.data ? state.data.stage : '';
            if (dataStage == 'INITIAL'
                || dataStage == 'NO_LICENSE'
                || dataStage == 'EXTERNAL_LOCAL'
                || dataStage == 'EXTERNAL_REMOTE'
                || dataStage == 'PENDING_METADATA_MOVE'
                || dataStage == 'LEGACY') {
                var taskState = state.task.state;
                if ((state.pending && state.pending.length > 0) || taskState == 'RUNNING' || taskState == 'FAILING' || taskState == 'CANCELLING') {
                    return svnmirror.statusProgress({status : buildStatus(state)});
                }
                return AJS.$('<div />');
            }
            return svnmirror.status({status : buildStatus(state)});
        });

        var parentRender = statusView.render;

        statusView.render = function(selector, state, actions) {
            var taskName = state.task.name;
            var taskState = state.task.state;

            if (taskName == 'install' || taskName == 'pause' || taskName == 'configure' || taskName == 'uninstall') {

                if ((taskState == 'SUCCESS' || taskState == 'FAILED' || taskState == 'CANCELLED')
                        && taskState != statusView.prevTaskState
                        && statusView.prevTaskName
                        && statusView.prevTaskName != 'bootstrap'
                        && (statusView.prevTaskState == 'RUNNING' || statusView.prevTaskState == 'CANCELLING' || statusView.prevTaskState == 'FAILING')) {
                    if (statusView.closer) {
                        window.clearTimeout(statusView.closer);
                        statusView.closer = null;
                    }

                    var title = 'Task "' + taskName + '" ' + taskState;

                    var flag = svnmirror.flag({ type : 'success', title : title, message : '', closeable : true});
                    form.renderTemplate(AJS.$('#svnmirror-remote-flag'), flag);
                    AJS.$('#svnmirror-remote-flag .icon-close').click(function() {
                        if (statusView.closer) {
                            window.clearTimeout(statusView.closer);
                            statusView.closer = null;
                        }
                        AJS.$('#svnmirror-remote-flag div').hide(400, function() {
                            AJS.$('#svnmirror-remote-flag').empty();
                        });
                    });
                    if (taskState != 'FAILED') {
                        statusView.closer = window.setTimeout(function() {
                            AJS.$('#svnmirror-remote-flag div').hide(400, function() {
                                AJS.$('#svnmirror-remote-flag').empty();
                            });
                        }, 5000);
                    }
                }
                statusView.prevTaskState = taskState;
                statusView.prevTaskName = taskName;
            }

            parentRender(selector, state, actions);
        };

        return statusView;
    };

    exports.retrievingStatus = retrievingStatus;
    exports.sendingCommandStatus = sendingCommandStatus;
});