define('tmatesoft/svnmirror/install', [
    '@atlassian/aui',
    'bitbucket/util/navbuilder',
    'bitbucket/util/state',
    'exports',
    'tmatesoft/svnmirror/controller',
    'tmatesoft/svnmirror/credentials',
    'tmatesoft/svnmirror/util/url',
    'tmatesoft/svnmirror/util/form'
], function(
    AJS,
    nav,
    pageState,
    exports,
    controller,
    credentialsUtil,
    urlUtil,
    form) {

    exports.view = function() {
        var view = controller.view(function(state) {
            return svnmirror.installForm({ config : state.data });
        });

        var parentModelUpdated = view.modelUpdated;
        var parentRender = view.render;

        view.getConfig = function() {
            return view.state.data;
        };

        view.getViewElement = function(modelId) {
            if (modelId && modelId.indexOf('data.') === 0) {
                var uiId = modelId.substring('data.'.length);
                uiId = '#' + uiId.replace('.', '\\.');
                return view.view.find(uiId);
            }
            return null;
        };

        view.tweak = function() {
            var parent = view.view;

            AJS.tabs.setup();
            if (window.location.hash && window.location.hash.substring(1) == 'unsynced') {
                AJS.tabs.change(AJS.$('a[href="#unsynced-tab"]'));
            } else {
                AJS.tabs.change(AJS.$('a[href="#config-tab"]'));
            }
            parent.find('textarea').attr('spellcheck', false);
            parent.find('#url, #defaultDomain').attr('spellcheck', false);
            form.addBadge(parent.find('#url'));


            var maxHeight = 0;
            var buttonsHeight = parent.find('.buttons-container').outerHeight(true);
            parent.find('.tabs-pane').each(function() {
                if (AJS.$(this).attr('id') != 'unsynced-tab' && AJS.$(this).attr('id') != 'credentials-tab') {
                    maxHeight = Math.max(maxHeight, AJS.$(this).height());
                }
            });

            if (maxHeight > 0) {
                parent.find('.tabs-pane').each(function() {
                    if (AJS.$(this).attr('id') == 'unsynced-tab') {
                        AJS.$(this).height(maxHeight + buttonsHeight);
                    } else {
                        AJS.$(this).height(maxHeight);
                    }
                });
            }

            credentialsUtil.tweakView(view);
        };

        view.bind = function() {
            var parent = view.view;

            form.selectAllOnFocus(parent.find('#url, #defaultDomain'));
            form.trackFieldChanges(parent.find('#url, #defaultDomain, #config, #authors, #useLocalAuthorsMapping, #useGlobalAuthorsMapping, #useStashAuthorsMapping, #defaultDomain'),
                function(field, value) {
                    controller.setModelValue(view.getConfig(), field.attr('id'), value);
                    view.update();
                });

            parent.find('.tabs-menu a').bind('tabSelect', function() {
                view.updateButtons();
            });

            credentialsUtil.bindView(view);
        };

        view.updateButtons = function() {
            var parent = view.view;

            var unsyncedActive = parent.find('.unsynced-tab').hasClass('active-tab');
            if (unsyncedActive) {
                parent.find('.buttons-container').hide();
                return false;
            }
            var config = view.getConfig();
            var stage = view.state.data.stage;
            var isConfigValid = config.config.trim() != '';
            var isCredentialsValid = credentialsUtil.updateView(view);
            var isUrlValid = urlUtil.isValidUrl(config.url);
            var isDomainValid = config.defaultDomain && config.defaultDomain.trim() != '';

            var hasChanges = view.controller.hasChanges();
            form.setEnabled(parent.find('#uninstall-button'), true);
            form.setEnabled(parent.find('#revert-button'), hasChanges);
            form.setEnabled(parent.find('#stop-button'), stage == 'INSTALLED');
            form.setEnabled(parent.find('#start-button'), stage == 'PAUSED' || stage == 'CONFIGURED');
            form.setEnabled(parent.find('#apply-button'), isUrlValid && isCredentialsValid && isConfigValid && hasChanges && isDomainValid);

            parent.find('#start-button').val(AJS.I18n.getText('svnmirror.settings.installForm.start.label'));
            parent.find('#stop-button').val(AJS.I18n.getText('svnmirror.settings.installForm.stop.label'));
            parent.find('#apply-button').val(AJS.I18n.getText('svnmirror.settings.installForm.apply.label'));

            if (stage == 'CONFIGURED') {
                parent.find('#uninstall-button').val(AJS.I18n.getText('svnmirror.settings.installForm.back.label'));
                parent.find('#start-button').show();
                parent.find('#stop-button').hide();
            } else if (stage == 'INSTALLED') {
                parent.find('#uninstall-button').val(AJS.I18n.getText('svnmirror.settings.installForm.uninstall.label'));
                parent.find('#start-button').hide();
                parent.find('#stop-button').show();
            } else if (stage == 'PAUSED') {
                parent.find('#uninstall-button').val(AJS.I18n.getText('svnmirror.settings.installForm.uninstall.label'));
                parent.find('#stop-button').hide();
                parent.find('#start-button').show();
            }
            parent.find('.buttons-container').show();
            form.setEnabled(parent.find('#testConnection-button'), isCredentialsValid && isConfigValid && isUrlValid);

            form.updateBadge(parent.find('#url'), isUrlValid ? 'aui-iconfont-approve' : 'aui-iconfont-error',
                isUrlValid ?
                        AJS.I18n.getText('svnmirror.settring.configureForm.url.badge.valid') :
                        AJS.I18n.getText('svnmirror.settring.configureForm.url.badge.notValid'));

            return true;
        };

        view.update = function() {
            var parent = view.view;
            var config = view.getConfig();
            var stage = view.state.data.stage;

            form.setEnabled(parent.find('#authors'), config.useLocalAuthorsMapping);
            view.updateButtons();
        };

        view.modelUpdated = function(delta) {
            view.updateUnsyncedTab();
            parentModelUpdated(delta);
        };

        view.render = function(formSelector, state, actions) {
            parentRender(formSelector, state, actions);
            view.updateUnsyncedTab();
        };

        view.updateUnsyncedTab = function() {
            var parent = view.view;
            var config = view.getConfig();
            var container = parent.find('#unsynced-rows');
            container.empty();

            if (config.unsyncedRefs && config.unsyncedRefs.length > 0) {
                for(var i = 0; i < config.unsyncedRefs.length; i++) {
                    var description = config.unsyncedRefs[i];
                    var commitLink = nav.project(pageState.getProject().key).repo(pageState.getRepository().slug).commit(description.commitId).build();
                    var unsyncedRow = svnmirror.unsyncedRow({
                        unsynced : description,
                        shortCommitId : description.commitId.substring(0, 10),
                        commitLink : commitLink
                    });
                    container.append(unsyncedRow);
                }
                parent.find('.unsynced-tab').show();
            } else {
                if (parent.find('.unsynced-tab').hasClass('active-tab')) {
                    AJS.tabs.change(AJS.$('a[href="#credentials-tab"]'));
                }
                parent.find('.unsynced-tab').hide();
            }
        };

        return view;
    };
});
