define('tmatesoft/svnmirror/credentials', [
    '@atlassian/aui',
    'exports',
    'bitbucket/util/navbuilder',
    'tmatesoft/svnmirror/controller',
    'tmatesoft/svnmirror/aux',
    'tmatesoft/svnmirror/util/form',
    'tmatesoft/svnmirror/util/json'
], function(
    AJS,
    exports,
    nav,
    controller,
    aux,
    form,
    json) {

    var buildFileUploadUrl = function(scope) {
        return '?command=upload-file';
    };

    var buildTestConnectionUrl = function(scope) {
        return '?command=test-connection';
    };

    var uploadFile = function(scope, fileObject, successFunc, error, complete) {
        var formData = new FormData();
        formData.append('file', fileObject);

        AJS.$.ajax({
            url : buildFileUploadUrl(scope),
            data : formData,
            processData : false,
            contentType : false,
            dataType : 'json',
            type : 'POST',
            success : function(data) {
                successFunc(json.decode(data));
            },
            error : error,
            complete : complete
        });
    };

    exports.testConnection = function(state) {
        var button = AJS.$('#testConnection-button');
        form.setEnabled(button, false);
        var originalText = button.text();
        button.text('Testing Connection...');

        AJS.$.ajax({
            url : buildTestConnectionUrl(state.scope),
            data: JSON.stringify(json.encode(state)),
            dataType: 'json',
            type : 'POST',
            contentType: 'application/json; charset=utf-8',
            success : function(data) {
                data = json.decode(data);
                if (!data.readAccess) {
                    data.error = data.error || 'unknown error';
                    aux.showFlag('error', 'Connection Test Failed', '<pre>' + data.error + '</pre>');
                } else if (!data.writeAccess) {
                    data.error = data.error || 'unknown error';
                    aux.showFlag('warning', 'No Write Access', '<pre>' + data.error + '</pre>');
                } else {
                    aux.showFlag('success', 'Connection Test Successful', 'Read Access: OK<br/>Write Access: OK');
                }
            },
            error : function(xhr, status, err) {
                aux.showFlag('error', 'Connection Test Failed', xhr.responseText);
            },
            complete : function() {
                button.text(originalText);
                form.setEnabled(button, true);
            }
        });
    };

    exports.tweakView = function(view) {
        var parent = view.view;
        parent.find('#credentials\\.userName, #credentials\\.password, #credentials\\.sslPassword, #credentials\\.passphrase').attr('spellcheck', false);
        var button = parent.find('#testConnection-button');
        button.appendTo(button.prev());
    };

    exports.bindView = function(view) {
        var parent = view.view;

        parent.find('#sshKey-upload, #sslCert-upload').click(function(event) {
            event.preventDefault();
            parent.find('#' + AJS.$(this).attr('id') + '-field').click();
            return false;
        });

        parent.find('#sshKey-upload-field, #sslCert-upload-field').change(function(event) {
            event.preventDefault();
            var source = AJS.$(this);
            var sourceId = source.attr('id');
            var fileInputElement = document.getElementById(sourceId);
            if (!fileInputElement || !fileInputElement.files || fileInputElement.files.length < 1) {
                return false;
            }
            var fileObject = fileInputElement.files[0];
            if (!fileObject) {
                return false;
            }

            var filePath = AJS.$(this).val();
            if (filePath) {
                var fileName = filePath.split(/(\\|\/)/g).pop();
                form.setEnabled(parent.find('#sshKey-upload, #sslCert-upload'), false);
                uploadFile(view.state.scope, fileObject,
                    function(data) {
                        if (data && data.error) {
                            aux.showFlag('error', 'Failed to Upload File', data.error);
                        } else if (data && data.fileName) {
                            var targetValueId = 'credentials.' + (sourceId.indexOf('ssl') == 0 ? 'sslCertValue' : 'sshKeyValue');
                            var targetPathId = 'credentials.' + (sourceId.indexOf('ssl') == 0 ? 'sslCert' : 'sshKey');
                            controller.setModelValue(view.getConfig(), targetValueId, data.fileName);
                            controller.setModelValue(view.getConfig(), targetPathId, fileName);
                        }
                    },
                    function(xhr, status, err) {
                        aux.showFlag('error', 'Failed to Upload File', xhr.responseText);
                    },
                    function() {
                        source.replaceWith(source.clone(true));
                        view.update();
                    });
            }
            return false;
        });

        form.selectAllOnFocus(parent.find('#credentials\\.userName, #credentials\\.password, #credentials\\.passphrase, #credentials\\.sslPassword'));
        form.trackFieldChanges(parent.find('#credentials\\.useCache, #credentials\\.useSshAgent, #credentials\\.type, #credentials\\.userName, #credentials\\.password, #credentials\\.passphrase, #credentials\\.sslPassword'),
            function(field, value) {
                controller.setModelValue(view.getConfig(), field.attr('id'), value);
                view.update();
            });
     };

     exports.updateView = function(view) {
        var parent = view.view;
        var config = view.getConfig();
        var credentials = config.credentials;

        var isCredentialsValid = credentials.useCache || credentials.userName && credentials.userName != '';

        var noPathValue = AJS.I18n.getText('svnmirror.settings.configureForm.file.noValue');
        parent.find('#sshKey-view').text(credentials.sshKey ? credentials.sshKey : noPathValue);
        parent.find('#sslCert-view').text(credentials.sslCert ? credentials.sslCert : noPathValue);

        form.setEnabled(parent.find('#credentials\\.userName, #credentials\\.password, #credentials\\.sshKey, #credentials\\.useSshAgent, #credentials\\.sslCert, #credentials\\.sslPassword, #credentials\\.passphrase, #credentials\\.type'), !credentials.useCache);
        form.setEnabled(parent.find('#sslCert-upload'), !credentials.useCache);
        form.setEnabled(parent.find('#sshKey-upload'), !credentials.useCache && !credentials.useSshAgent);
        form.setEnabled(parent.find('#credentials\\.passphrase'), !credentials.useCache && !credentials.useSshAgent);

        parent.find('#sshKey-view').parent().toggle(credentials.type == 'SSH');
        parent.find('#sslCert-view').parent().toggle(credentials.type == 'SSL');
        parent.find('#credentials\\.useSshAgent').parent().toggle(credentials.type == 'SSH');
        parent.find('#credentials\\.sslPassword').parent().toggle(credentials.type == 'SSL');
        parent.find('#credentials\\.passphrase').parent().toggle(credentials.type == 'SSH' || credentials.type == 'SSL');
        parent.find('#credentials\\.password').parent().toggle(!credentials.type || credentials.type == 'SIMPLE');

        if (!credentials.useCache) {
            if (credentials.type == 'SSH') {
                isCredentialsValid &= (credentials.sshKey && credentials.sshKey != '') || credentials.useSshAgent;
            } else if (credentials.type == 'SSL') {
                isCredentialsValid &= credentials.sslCert && credentials.sslCert != '';
            }
        }

        return isCredentialsValid;
     };

});