define('tmatesoft/svnmirror/configure', [
    '@atlassian/aui',
    'exports',
    'bitbucket/util/navbuilder',
    'tmatesoft/svnmirror/controller',
    'tmatesoft/svnmirror/credentials',
    'tmatesoft/svnmirror/util/tree-dialog',
    'tmatesoft/svnmirror/util/url',
    'tmatesoft/svnmirror/util/form'
], function(
    AJS,
    exports,
    nav,
    controller,
    credentialsUtil,
    tree,
    urlUtil,
    form) {

    exports.view = function() {
        var view = controller.view(function(state) {
            return svnmirror.configureForm({ config : state.data });
        });

        view.getConfig = function() {
            return view.state.data;
        };

        view.getViewElement = function(modelId) {
            if (modelId && modelId.indexOf('data.') === 0) {
                var uiId = modelId.substring('data.'.length);
                uiId = '#' + uiId.replace('.', '\\.');
                return view.view.find(uiId);
            }
            return null;
        };

        view.tweak = function() {
            var parent = view.view;
            form.addBadge(parent.find('#url, #trunkPath'));
            parent.find('#url, #defaultDomain').attr('spellcheck', false);
            credentialsUtil.tweakView(view);
        };

        view.bind = function() {
            var parent = view.view;

            parent.find('#trunkPath-button').click(function(e) {
                e.preventDefault();
                var jsonUrl = '?command=get-subversion-tree';
                tree.show('#trunk-dialog',
                    svnmirror.trunkDialog(),
                    jsonUrl,
                    view.state,
                    function(path) {
                        view.getConfig().trunkPath = path;
                        view.getConfig().trunkPathUrl = view.getConfig().url;
                        view.update();
                    });
                return false;
            });

            parent.find('input[type!="submit"]').keypress(function(event) {
                var code = event.keyCode || event.which;
                if (code == 13) {
                    event.preventDefault();
                    parent.find('#configureForm-button').click();
                    return false;
                }
            });

            form.selectAllOnFocus(parent.find('#url, #defaultDomain'));
            form.trackFieldChanges(parent.find('#url, #defaultDomain'),
                function(field, value) {
                    controller.setModelValue(view.getConfig(), field.attr('id'), value);
                    view.update();
                });
            form.trackFieldChanges(parent.find('#manualLayout, #autoLayout, #singleDirectory'),
                function(field, value) {
                    if (!field.is(':checked')) {
                        return;
                    }
                    var id = field.attr('id');
                    var value = 'AUTO';
                    if (id == 'manualLayout') {
                        value = 'MANUAL';
                    } else if (id == 'autoLayout') {
                        value = 'AUTO';
                    } else if (id == 'singleDirectory') {
                        value = 'DIRECTORY';
                    }
                    controller.setModelValue(view.getConfig(), 'layoutType', value);
                    view.update();
                });

            credentialsUtil.bindView(view);
        };

        var parentModelUpdated = view.modelUpdated;

        var modelUpdated = function(delta) {
            var config = view.getConfig();
            var parent = view.view;
            var layoutType = config.layoutType;

            parent.find('#autoLayout').prop('checked', layoutType == 'AUTO');
            parent.find('#manualLayout').prop('checked', layoutType == 'MANUAL');
            parent.find('#singleDirectory').prop('checked', layoutType == 'DIRECTORY');

            parentModelUpdated(delta);
        };

        view.update = function() {
            var parent = view.view;
            var config = view.getConfig();

            var isUrlValid = urlUtil.isValidUrl(config.url);
            var isAutoLayout = config.layoutType == 'AUTO';
            var isModeValid = !isAutoLayout || (isAutoLayout && config.trunkPath);
            var isCredentialsValid = credentialsUtil.updateView(view);
            var isDomainValid = config.defaultDomain && config.defaultDomain.trim() != '';
            var somethingIsRunning = (view.state.pending && view.state.pending.length > 0) ||
                (view.state.task
                    && view.state.task.state != 'SUCCESS'
                    && view.state.task.state != 'FAILED'
                    && view.state.task.state != 'INAPPLICABLE'
                    && view.state.task.state != 'CANCELLED');

            form.setEnabled(parent.find('#trunkPath-button'), isUrlValid && isCredentialsValid && isAutoLayout);
            form.setEnabled(parent.find('#configure-button'), !somethingIsRunning && isUrlValid && isCredentialsValid && isModeValid && isDomainValid);
            parent.find('#trunkPath').text(config.trunkPath ? config.trunkPath : AJS.I18n.getText('svnmirror.settings.configureForm.selectTrunk.noValue'));
            parent.find('#trunkPath').toggleClass('trunkPath-disabled', !isAutoLayout || !config.trunkPath);

            if (config.trunkPath && config.url && config.url != config.trunkPathUrl) {
                form.updateBadge(parent.find('#trunkPath'), 'aui-iconfont-warning', AJS.I18n.getText('svnmirror.settring.configureForm.selectTrunk.badge.urlChanged'));
            } else if (isAutoLayout && !config.trunkPath) {
                if (!isUrlValid) {
                    form.updateBadge(parent.find('#trunkPath'), 'aui-iconfont-error', AJS.I18n.getText('svnmirror.settring.configureForm.selectTrunk.badge.selectPathInvalidURL'));
                } else {
                    form.updateBadge(parent.find('#trunkPath'), 'aui-iconfont-error', AJS.I18n.getText('svnmirror.settring.configureForm.selectTrunk.badge.selectPath'));
                }
            } else {
                form.updateBadge(parent.find('#trunkPath'), null, '');
            }

            form.updateBadge(parent.find('#url'), isUrlValid ? 'aui-iconfont-approve' : 'aui-iconfont-error',
                isUrlValid ?
                        AJS.I18n.getText('svnmirror.settring.configureForm.url.badge.valid') :
                        AJS.I18n.getText('svnmirror.settring.configureForm.url.badge.notValid'));
            form.setEnabled(parent.find('#revert-button'), view.controller.hasChanges());
            form.setEnabled(parent.find('#testConnection-button'), isCredentialsValid && isUrlValid);
        };

        return view;
    };

});