define('tmatesoft/svnmirror/aux', [
    '@atlassian/aui',
    'exports',
    'bitbucket/util/navbuilder',
    'tmatesoft/svnmirror/util/form',
    'tmatesoft/svnmirror/controller'
    ],
function(
    AJS,
    exports,
    nav,
    form,
    controller) {

    exports.externalView = function() {
        var view = controller.view(function(state) {
            return svnmirror.externalForm();
        });

        view.update = function() {
            var parent = view.view;
            form.setEnabled(parent.find('#refresh-button'), true);
        };

        return view;
    };

    exports.noLicenseView = function() {
        var view = controller.view(function(state) {
            return svnmirror.noLicenseForm();
        });

        view.update = function() {
            var parent = view.view;
            form.setEnabled(parent.find('#license-button'), true);
        };
        return view;
    };

    var closer = null;
    var clearTimeout = function() {
        if (closer) {
            window.clearTimeout(closer);
            closer = null;
        }
    };

    var closeFlag = function(timeout) {
        clearTimeout();
        if (timeout) {
            closer = window.setTimeout(closeFlag, 10*1000);
            return;
        }
        AJS.$('#svnmirror-local-flag div').hide(400, function() {
            AJS.$('#svnmirror-local-flag').empty();
        });
    };

    exports.showFlag = function(type, title, message) {
        clearTimeout();
        AJS.$('#svnmirror-local-flag').empty();
        var flag = svnmirror.flag({ type : type, title : title, message : message, closeable : true});
        form.renderTemplate(AJS.$('#svnmirror-local-flag'), flag);
        if (type == 'success') {
            closeFlag(10*1000);
        }
        AJS.$('#svnmirror-local-flag .icon-close').click(function() {
            closeFlag();
        });

    };
});