define('pull-request/pull-request-manual-merge',
    ['exports', 'page/pull-request/pull-request-view'],
    function(exports, pullRequestView) {
        // Registers the handler for a given feature, which in this case is a PR tab
        // This allows for purely client-side behaviour instead of having a full page refresh for each tab
        pullRequestView.registerHandler(
            // NOTE: This needs to match the web-item
            'stash.pull-request.nav.merge',
            // NOTE: This regex is very important and needs to match the servlet URL
            /^[^\?\#]*\/subgit_mirror\/.*?\/pull-requests\/\d+\/.*/,
            // The defined handler from below which handles load/unload
            'pull-request/pull-request-manual-merge-view');
    }
);

// Look at the following package for more examples
// webapp/default/src/main/webapp/static/page/pull-request/view
define('pull-request/pull-request-manual-merge-view', [
    'jquery',
    'model/page-state'
], function (
    $,
    pageState
    ) {
    return {
        load : function(el) {
            // Calls into the client-side soy to render stuff
            // May need to do a REST call to retrieve data
            var $view = ['<div><p>Run the following command to merge pull request manually:</p><pre>',
                '1. Clone target repository:',
                '',
                '<b>$ git clone ' + 'REPOSITORY_URL</b>',
                '',
                '2. Check out target branch:',
                '',
                '<b>$ git checkout ' + 'TARGET_BRANCH</b>',
                '',
                '3. Fetch pull request commit into a branch:',
                '   Pull request ID is part of this page URL: "../pull-requests/PULL_REQUEST_ID/merge"',
                '',
                '<b>$ git fetch origin refs/pull-requests/PULL_REQUEST_ID/from:TEMPORARY_BRANCH</b>',
                '',
                '4. Merge pull request into a target branch:',
                '',
                '<b>$ git merge ' + 'TEMPORARY_BRANCH</b>',
                '',
                '5. Push merge commit back to the target repository:',
                '',
                '<b>$ git push origin ' + 'TARGET_BRANCH</b>',
                '<pre></div>'
            ].join('\n');
            el.innerHTML = $view
        },
        unload : function(el) {
            // Maybe unload stuff here
        },
        keyboardShortcutContexts : ['mergePullRequest']
    };
});

// Need to ensure the customer handler is registered
require('pull-request/pull-request-manual-merge');