define('page/plugin/svn-import-settings',
['exports', 'jquery', '@atlassian/aui', 'page/plugin/svn-import-authors'],
function(exports, $, AJS, svnImportAuthors) {

    var WIZARD_ID = "#wizard"
    var SETTINGS_ID = '#settings';
    var AUTHORS_ID = '#authors';
    var AUTHORS_TAB_ID = '#authors-tabs';

    var STATUS_ID = '#status';
    var STATUS_URL_ID = '#statusURL';
    var STATUS_TRUNK_ID = '#statusTrunk';
    var STATUS_BRANCHES_ID = '#statusBranches';
    var STATUS_TAGS_ID = '#statusTags';
    var STATUS_SHELVES_ID = '#statusShelves';
    var STATUS_REVISION_ID = '#statusRevision';
    var STATUS_TOTAL_ID = '#statusTotal';
    var STATUS_COMMIT_ID = '#statusCommit';
    var STATUS_HEADER_ID = '#statusHeader';

    var BUTTON_ID = '#import-button';
    var RESET_BUTTON_ID = '#reset-button';
    var IMPORT_ONLY_BUTTON_ID = '#import-only';
    var MINIMAL_REVISION_ID = '#minimalRevision';

    var DEFAULT_MESSAGE = "Fill in the fields below and press 'Continue' button to proceed.";
    var GENERIC_PROGRESS_MESSAGE = 'Processing request...';
    var INITIAL_STATUS_MESSAGE = 'Hold on, retrieving current status...';

    var VALIDATOR = {
        shouldNotBeEmpty : function(name) {
            return function(value) {
                if (value === null || typeof value == 'undefined' || value.trim().length == 0) {
                    return name + ' should not be empty.';
                }
                return null;
            }
        },
        shouldBeNumber : function(name) {
            return function(value) {
                if (value === null || typeof value == 'undefined' || value.trim().length == 0) {
                    return name + ' should not be empty.';
                }
                var intRegex = /^\d+$/;
                if (!intRegex.test(value)) {
                    return name + ' should be a positive integer';
                }
                return null;
            }
        },
        validEmailOrEmpty : function(message) {
            return function(value) {
                if (value === null || typeof value == 'undefined' || value.trim().length == 0) {
                    return null;
                }
                var pattern = new RegExp(/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i);
                return pattern.test(value) ? null : ("&lt;" + value + "&gt; " + message);
            }
        }

    };
    VALIDATOR.url = VALIDATOR.shouldNotBeEmpty('Subversion Repository URL');
    VALIDATOR.trunk = VALIDATOR.shouldNotBeEmpty('Trunk mapping definition');
    VALIDATOR.branches = VALIDATOR.shouldNotBeEmpty('Branches mapping definition');
    VALIDATOR.tags = VALIDATOR.shouldNotBeEmpty('Tags mapping definition');
    VALIDATOR.shelves = VALIDATOR.shouldNotBeEmpty('Shelves mapping definition');
    VALIDATOR.minimalRevision = VALIDATOR.shouldBeNumber('Revision number');

    var WIZARD = {
        page : function(pageId) {
            return function(newState, oldState) {
                if (pageId == AUTHORS_TAB_ID) {
                    AJS.tabs.change($('a[href=#subgit-authors-tab]'));
                }
                
                var pageHeight = 0;
                $(WIZARD_ID).children().each(function () {
                    if (pageHeight == 0 && $(this).css('display') != 'none') {
                        pageHeight = $(this).height();
                    }
                    $(this).css('display', '#' + $(this).attr('id') != pageId ? 'none' : 'block');
                    if (pageHeight != 0 && $(this).css('display') != 'none') {
                        $(this).css('height', pageHeight);
                        $(this).css('maxHeight', pageHeight);
                    }
                });
                $(".page-description").each(function() {
                    if ('#' + $(this).attr('id') != pageId + '-description') {
                        $(this).addClass('disabled-description');
                    } else {
                        $(this).removeClass('disabled-description');
                    }
                });
            };
        },
        enabled : function(isEnabled) {
            return function(newState, oldState) {
                setAllEnabled(WIZARD_ID, isEnabled);
            };
        },
        showLog : function(show) { return function(newState, oldState) { setLog(show ? newState.log : null); } },
        message : function(kind, text) {
            return function(newState, oldState) {
                newState.pausing = false;
                setMessage(text == null ? newState.status.message : text, kind);
            };
        },
        messageUnlessPausing: function(kind, text) {
            return function(newState, oldState) {
                if (!oldState.pausing) {
                    setMessage(text == null ? newState.status.message : text, kind);
                }
            };
        },
        button : function(text, isEnabled, action) {
            return function(newState, oldState) {
                if (!newState.pausing) {
                    enable(BUTTON_ID, isEnabled);
                    $(BUTTON_ID).val(text);
                }

                if (typeof action === 'undefined') {
                    action = null;
                }
                $(SETTINGS_ID).data('action', action);
            };
        },

        scheduleUpdate: function(timeout) { return function(newState, oldState) { scheduleRequest(createStatusRequest(), timeout) }; },

        initInputs: function(newState, oldState) {
                    $(RESET_BUTTON_ID).hide();
            $(SETTINGS_ID + ' input').each(function(i, element) {
                $(element).change(function(e) {
                    e.preventDefault();
                    setMessage(DEFAULT_MESSAGE, 'info');
                    return false;
                });
            });

            $(SETTINGS_ID).on('submit', function(e) {
                e.preventDefault();
                if (typeof $(SETTINGS_ID).data('action') == 'function') {
                    $(SETTINGS_ID).data('action')(state);
                }
                return false;
            });

            $(BUTTON_ID).on('click', function(e) {
                e.preventDefault();
                enable(BUTTON_ID, false);
                if (typeof $(SETTINGS_ID).data('action') == 'function') {
                    if ($(SETTINGS_ID).data('action')(state)) {
                        enable(BUTTON_ID, true);
                    }
                }
                return false;
            });

            $(IMPORT_ONLY_BUTTON_ID).on('click', function(e) {
                enable("#shelves", !$(IMPORT_ONLY_BUTTON_ID).is(':checked'));
                return true;
            });
            
            $('#subgit-config-checkbox').change(
                function(){
                    enable('#subgit-config', $(this).is(':checked'));
                });
        },
    };

    var WIZARD_ACTIONS = {
        INIT: [WIZARD.page(SETTINGS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('generic', INITIAL_STATUS_MESSAGE), WIZARD.button('Continue', false), WIZARD.initInputs, WIZARD.scheduleUpdate(0)],
        NONE: [WIZARD.page(SETTINGS_ID), WIZARD.enabled(true), WIZARD.showLog(false), WIZARD.message('info', DEFAULT_MESSAGE), WIZARD.button('Continue', true, doImport)],
        UNKNOWN: [WIZARD.page(SETTINGS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('error', 'Unknown Status Response'), WIZARD.button('Continue', false)],
        NOT_EMPTY: [WIZARD.page(SETTINGS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('info'), WIZARD.button('Continue', false)],

        PROGRESS_REVISION: [WIZARD.page(STATUS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.messageUnlessPausing('generic'), WIZARD.button('Pause', true, doPause), updateStatus],

        PROGRESS_START: [WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.messageUnlessPausing('generic'), WIZARD.button('Pause', false)],
        PROGRESS_FINISH: [WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.messageUnlessPausing('generic'), WIZARD.button('Import Completed', false)],
        PROGRESS_AUTHORS: [WIZARD.page(SETTINGS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.messageUnlessPausing('generic'), WIZARD.button('Continue', false)],

        COMPLETED_OK : [WIZARD.page(STATUS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('success'), WIZARD.button('Import Completed', true, doUninstall), updateStatus],
        COMPLETED_UNINSTALL : [WIZARD.page(STATUS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('warning'), WIZARD.button('Uninstalled', false), updateStatus],
        COMPLETED_CANCELLED : [WIZARD.page(STATUS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('warning'), WIZARD.button('Resume', true, doImport)],
        COMPLETED_AUTHORS : [WIZARD.page(AUTHORS_TAB_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('success'),
            WIZARD.button('Continue',  true, doSaveAuthorsAndImport), authorsReady /* updates page */],

        COMPLETED_ERROR : [WIZARD.page(SETTINGS_ID), WIZARD.enabled(true), WIZARD.showLog(true), WIZARD.message('error'), WIZARD.button('Continue', true, doImport)],
        COMPLETED_AUTH_ERROR : [WIZARD.page(SETTINGS_ID), WIZARD.enabled(true), WIZARD.showLog(false), WIZARD.message('error'), WIZARD.button('Continue', true, doImport)],
        COMPLETED_RECOVERABLE_ERROR : [WIZARD.page(STATUS_ID), WIZARD.enabled(false), WIZARD.showLog(true), WIZARD.message('warning'), WIZARD.button('Resume', true, doImport)],

        PROGRESS_SYNC : [WIZARD.page(STATUS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('success'), WIZARD.button('Uninstall', true, doUninstall), updateStatus],
        PROGRESS_UNINSTALL : [WIZARD.page(STATUS_ID), WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('generic'), WIZARD.button('Uninstalling', false)],

        LICENSE : [WIZARD.enabled(false), WIZARD.showLog(false), WIZARD.message('error'), WIZARD.button('Get License', true, doGetLicense), updateStatus],
    };

    exports.onReady = function() {
        update(state);
    };

    var authorsDialog;

    function doSaveAuthorsAndImport(state) {
        if (authorsDialog != null) {
            authorsDialog.apply(false);
            state.settings.authors = authorsDialog.data;
        }
        authorsDialog = null;
        enable(AUTHORS_TAB_ID + " input", false);
        enable(AUTHORS_TAB_ID + " button", false);
        doImport(state)
    }

    function doGetLicense(state) {
        document.location = state.licenseUrl;
        return false;
    }

    function doUninstall(state) {
        var importOnly = state.settings['import-only'];
        var rc = false;
        if(importOnly) {
            rc = window.confirm('You\'re about to delete import related files (logs) from this repository.\n' +
                'This action cannot be undone.\n' +
                'Would you like to proceed?');
        } else {
            rc = window.confirm('You\'re about to deactivate synchronization with Subversion for this repository.\n' +
                'This action cannot be undone.\n' +
                'Would you like to proceed with uninstall?');
        }
        if (!rc) {
            return true;
        }
        if (state.settings == null) {
            state.settings = {};
        }
        var form = serializeForm(SETTINGS_ID);
        for(p in form) {
            if (form.hasOwnProperty(p)) {
                state.settings[p] = form[p];
            }
        }
        setAllEnabled(SETTINGS_ID, false);
        setMessage("Uninstalling...", 'generic');
        var request = createUninstallRequest();
        if (importOnly) {
            request.callback = function() { scheduleRequest(createStatusRequest(), 1000); };
        }
        postRequest(request);
        return false;
    }

    function doImport(state) {
        if (state.settings == null) {
            state.settings = {};
        }
        var form = serializeForm(SETTINGS_ID);
        for(p in form) {
            if (form.hasOwnProperty(p)) {
                state.settings[p] = form[p];
            }
        }
        if ($('#subgit-config-checkbox').is(':checked')) {
           state.settings.config = $('#subgit-config').val(); 
        } else {
           delete state.settings.config;
        }
        setAllEnabled(SETTINGS_ID, false);
        setMessage(GENERIC_PROGRESS_MESSAGE, 'generic');

        var validation = validateForm(SETTINGS_ID, VALIDATOR);
        if (validation != null) {
            setMessage(validation.message, 'error');
            setAllEnabled(SETTINGS_ID, true);
            validation.field.focus();
            return true;
        } else {
            postRequest(createImportRequest());
        }

        return false;
    }

    function doInstall(state) {
        if (state.settings == null) {
            state.settings = {};
        }
        var form = serializeForm(SETTINGS_ID);
        for(p in form) {
            if (form.hasOwnProperty(p)) {
                state.settings[p] = form[p];
            }
        }
        if ($('#subgit-config-checkbox').is(':checked')) {
           state.settings.config = $('#subgit-config').val(); 
        } else {
           delete state.settings.config;
        }
        
        setAllEnabled(SETTINGS_ID, false);
        setMessage(GENERIC_PROGRESS_MESSAGE, 'generic');
        var validation = validateForm(SETTINGS_ID, VALIDATOR);
        if (validation != null) {
            setMessage(validation.message, 'error');
            setAllEnabled(SETTINGS_ID, true);
            validation.field.focus();
            return true;
        } else {
            postRequest(createInstallRequest());
        }
        return false;
    }

    function doPause(state) {
        setAllEnabled(SETTINGS_ID, false);
        state.pausing = true;
        setMessage('Interrupting import operation gracefully...', 'generic');
        $(BUTTON_ID).val('Pausing...');
        postRequest(createCancelRequest());
        return false;
    }

    function doEditAuthors(state) {
        enable('#subgit-config-checkbox', true);
        if (state.settings.config && state.settings.config != null) {
            enable('#subgit-config', true);
            $('#subgit-config').val(state.settings.config);
        } else {
            enable('#subgit-config', false);
            $('#subgit-config').val('');
        }
        $('#subgit-config-checkbox').prop('checked', false);
        enable('#subgit-config', $('#subgit-config-checkbox').is(':checked'));
        
        $('#subgit-config').css('height', $(SETTINGS_ID).height() - 80);
        $('#subgit-config').css('min-height', $(SETTINGS_ID).height() - 80);
        $('#subgit-config').css('max-height', $(SETTINGS_ID).height() - 80);
        
        $(RESET_BUTTON_ID).one('click', function() {
            if (authorsDialog != null) {
              authorsDialog.apply(false);
              state.settings.authors = authorsDialog.data;
            }
            if ($('#subgit-config-checkbox').is(':checked')) {
               state.settings.config = $('#subgit-config').val(); 
            } else {
               delete state.settings.config;
            }

            authorsDialog = null;
            enable(AUTHORS_ID + " input", false);
            enable(AUTHORS_ID + " button", false);
            enable('#subgit-config-checkbox', false);
            enable('#subgit-config', false);
            enable(BUTTON_ID, false);
            enable(RESET_BUTTON_ID, false);
            setAllEnabled(SETTINGS_ID, false);
            postRequest(createResetRequest());
        });
        showMappingDialog(state);
        return false;
    }

    function authorsReady(newState, oldState) {
        doEditAuthors(newState);
    }

    function updateStatus(newState, oldState) {
        var importOnly = newState.settings['import-only'];
        if (newState.status != null && importOnly) {
            $(STATUS_ID + ' #statusNote').css('display', 'none');
            $(STATUS_ID + ' #statusImportNote').css('display', 'block');
        }
        if (newState.settings != null) {
            $(STATUS_ID + " " + STATUS_URL_ID).text(newState.settings.url);
            $(STATUS_ID + " " + STATUS_URL_ID).attr('href', newState.settings.url);
            $(STATUS_ID + " " + STATUS_TRUNK_ID).text(newState.settings.trunk);
            $(STATUS_ID + " " + STATUS_BRANCHES_ID).text(newState.settings.branches);
            $(STATUS_ID + " " + STATUS_TAGS_ID).text(newState.settings.tags);
            $(STATUS_ID + " " + STATUS_SHELVES_ID).text(newState.settings.shelves);
        } else {
            $(STATUS_ID + " " + STATUS_URL_ID).text('');
            $(STATUS_ID + " " + STATUS_TRUNK_ID).text('');
            $(STATUS_ID + " " + STATUS_BRANCHES_ID).text('');
            $(STATUS_ID + " " + STATUS_TAGS_ID).text('');
            $(STATUS_ID + " " + STATUS_SHELVES_ID).text('');
        }

        if (newState.status != null) {
            $(STATUS_ID + " " + STATUS_REVISION_ID).text(newState.status.revision > 0 ? newState.status.revision : '');
            $(STATUS_ID + " " + STATUS_TOTAL_ID).text(newState.status.total > 0 ? newState.status.total : '');
            $(STATUS_ID + " " + STATUS_COMMIT_ID).text(newState.status.commit != null ? newState.status.commit : '');
            $(STATUS_ID + " " + STATUS_COMMIT_ID).attr('href', newState.status.commit != null ? newState.status.commit : '');
        } else {
            $(STATUS_ID + " " + STATUS_REVISION_ID).text('');
            $(STATUS_ID + " " + STATUS_TOTAL_ID).text('');
            $(STATUS_ID + " " + STATUS_COMMIT_ID).text('');
        }

        if (newState.status == null || newState.status.revision <= 0) {
            $(STATUS_ID + ' #statusInitial').css('display', 'none');
            $(STATUS_ID + ' #statusSync').css('display', 'none');
        } else if (newState.status != null && newState.status.kind == 'PROGRESS_REVISION') {
            $(STATUS_ID + ' #statusInitial').css('display', 'block');
            $(STATUS_ID + ' #statusSync').css('display', 'none');
        } else {
            $(STATUS_ID + ' #statusInitial').css('display', 'none');
            $(STATUS_ID + ' #statusSync').css('display', 'block');
        }

        if (newState.status != null && newState.status.kind == 'COMPLETED_UNINSTALL') {
            $(STATUS_ID + ' #statusHeader').parent().append('<p>' + newState.status.message  + '</p>')
        }

        if (newState.status != null && newState.status.revision > 0) {
            WIZARD.page(STATUS_ID)(newState, oldState);
        }
    }

    var state = {
        pausing: false,
        settings: {
            url: '',
            trunk: 'trunk',
            branches: 'branches/*',
            tags: 'tags/*',
            shelves: 'shelves/*',
            minimalRevision: 1,
            authors: {},
        },
        status: {
            kind: 'INIT',
            message: INITIAL_STATUS_MESSAGE,
        },
        log: null,
    };
    state.settings['generate-authors-mapping'] = true;

    function createStatusRequest() {
        return {
            data     : {request: 'STATUS'},
            callback : update,
        };
    }

    function createCancelRequest() {
        return {data : {request: 'CANCEL'}};
    }

    function createImportRequest() {
        return {
            data    : {request: 'IMPORT', settings: state.settings},
            callback: function() {scheduleRequest(createStatusRequest(), 1000)}
        };
    }

    function createInstallRequest() {
        return {
            data    : {request: 'INSTALL', settings: state.settings},
            callback: function() {scheduleRequest(createStatusRequest(), 1000)}
        };
    }

    function createResetRequest() {
        return {
            data    : {request: 'RESET', settings: state.settings},
            callback: function() {scheduleRequest(createStatusRequest(), 1000)}
        };
    }

    function createUninstallRequest() {
        return {
            data    : {request: 'UNINSTALL', settings: state.settings},
            callback: function() {}
        };
    }

    function createGetLicenseRequest() {
        return {
            data    : {request: 'LICENSE', settings: state.settings},
            callback: function() {}
        };
    }

    function createStoreRequest() {
        return {
            data    : {request: 'STORE',
                       status: state.status,
                       log: state.log,
                       settings: state.settings},
            callback: function() {}
        };
    }

    function postRequest(request) {
        $.post(document.URL, {'request' : JSON.stringify(request.data)}, request.callback, 'json')
        .error(function(jq, status, error) {
            alert(status + " : " + error);
        });
    }

    var longpollprocess = null;

    function scheduleRequest(request, timeout) {
        if (longpollprocess == null) {
            longpollprocess = longPoll;
            window.setTimeout(longpollprocess, timeout);
        }
    }

    function longPoll() {
        var maxPollInterval = 5000;
        var minPollInterval = 1000;
        var pollIntervalIncrement = 200;
        var pollInterval = minPollInterval;
        var expires = 0;

        if ($.browser.msie) {
            if (parseInt($.browser.version, 0) < 10) {
                expires = new Date().getTime() + 3000;
            }
        }

        var xhr = new XMLHttpRequest();
        var lastRead = 0;
        xhr.open('GET',
                document.URL + '/poll?timestamp=' + new Date().getTime() + '&expires=' + expires,
                true);
        xhr.send(null);

        var statusReader = function() {
            var isProgress = true;
            if (typeof(xhr.responseText) == 'unknown') {
                window.setTimeout(xhr.readyState != XMLHttpRequest.DONE ? statusReader : longPoll, pollInterval);
                return;
            }
            var allFeed = xhr.responseText;
            var unprocessed = allFeed.substring(lastRead);

            if (unprocessed.length > 0) {
                pollInterval = minPollInterval;
                var messageEnd = unprocessed.lastIndexOf('\n');
                if (messageEnd >= 0 && unprocessed.length > 0) {
                    var messageStart = messageEnd > 0 ? unprocessed.lastIndexOf('\n', messageEnd - 1) + 1 : 0;
                    lastRead += messageEnd + 1;
                    var message = unprocessed.substring(messageStart, messageEnd);

                    if (message != null && message.length > 0) {
                        var lastState = null;
                        try {
                            lastState = $.parseJSON(message);
                            isProgress = lastState != null
                                && lastState.status != null
                                && lastState.status.kind != null
                                && lastState.status.kind.indexOf('PROGRESS_') == 0;
                            update(lastState);
                        } catch (err) {
                            xhr.abort();
                        }
                    }
                }
            } else {
                if (pollInterval + pollIntervalIncrement <= maxPollInterval) {
                    pollInterval += pollIntervalIncrement;
                }
            }

            if (isProgress) {
                window.setTimeout(xhr.readyState != XMLHttpRequest.DONE ? statusReader : longPoll, pollInterval);
            } else {
                if (xhr.readyState != XMLHttpRequest.DONE) {
                    xhr.abort();
                }
                longpollprocess = null;
            }
        };
        window.setTimeout(statusReader, 100);
    }

    function serializeForm(id) {
       var form = {};
       $(id + ' :input:not(input[type=submit])').each(function() {
           var vid = $(this).attr('id');
           form[vid] = $(this).val();
       });
       form['generate-authors-mapping'] = $(id + ' #generate-authors-mapping').is(':checked');
       form['import-only'] = $(id + ' ' + IMPORT_ONLY_BUTTON_ID).is(':checked');
       form['minimalRevision'] = parseInt($(id + ' ' + MINIMAL_REVISION_ID).val());
       return form;
    }

    function fillForm(id, values) {
       $(id + ' :input:not(input[type=submit])').each(function() {
           var vid = $(this).attr('id');
           if (typeof values[vid] != 'undefined') {
               $(this).val(values[vid]);
           }
       });

       $(id + ' #generate-authors-mapping').prop('checked', values['generate-authors-mapping']);
    }

    function validateForm(id, validators) {
        var result = null;
        $(id + ' :input:not(input[type=submit])').each(function() {
            var vid = $(this).attr('id');
            if (typeof validators[vid] === 'function') {
                var msg = validators[vid]($(this).val());
                if (msg != null) {
                    result = {
                        field : $(this),
                        message: msg
                    };
                    return false;
                }
            }
        });
        return result;
    }

    function update(newState) {
        var oldState = state;

        state = newState;
        state.pausing = oldState.pausing;
        if (newState.settings != null) {
            fillForm(SETTINGS_ID, newState.settings);
        } else {
            newState.settings = oldState.settings;
        }

        if (newState.settings.authors == null
                || newState.settings.authors.length == 0) {
            newState.settings.authors = oldState.settings.authors;
        }

        var kind = newState.status.kind;
        var actions = WIZARD_ACTIONS[kind];
        if (actions == null) {
            actions = WIZARD_ACTIONS.UNKNOWN;
        }
        for(var i = 0; i < actions.length; i++) {
            actions[i](newState, oldState);
        }
        if (kind == 'COMPLETED_AUTHORS') {
          $(RESET_BUTTON_ID).show();
          enable(RESET_BUTTON_ID, true);
        } else {
          $(RESET_BUTTON_ID).hide();
        }
    }

    function showMappingDialog(data) {
        var Dialog = svnImportAuthors.dialog;
        var d = new Dialog({
            id: 'authors-dialog',
            title: 'Authors Mapping',
            comparator: function(a, b) {
                var c = a.svnName.toLowerCase().localeCompare(b.svnName.toLowerCase());
                if (c == 0) {
                    return a.gitName.toLowerCase().localeCompare(b.gitName.toLowerCase());
                }
                return c;
            },
            validators: {
                svnName: VALIDATOR.shouldNotBeEmpty('Subversion user name'),
                gitName: VALIDATOR.shouldNotBeEmpty('Git author name'),
                gitEmail: VALIDATOR.validEmailOrEmpty('is not a valid email address'),
            }});
        d.submitSelector = BUTTON_ID;
        d.onApply = function() {
            state.settings.authors = d.data;
            postRequest(createStoreRequest());
        }
        d.maxHeight = $(SETTINGS_ID).height();
        $('#authors').each(function() {
            d.setAuthorsPanel($(this));
        });
        d.load(data.settings.authors);

        authorsDialog = d;
    }

    function setMessage(message, type) {
        $('#message-text')[0].innerHTML = message;
        $('#message-pane').removeClass('generic info error success warning');
        $('#message-pane').addClass(type);
    }

    function setLog(path) {
        if (path == null) {
            $('#log-pane').css('display', 'none');
        } else {
            $('#log-pane').removeAttr('style');
            $('#log-link').attr('href', path);
        }
    }

    function setAllEnabled(id, isEnabled) {
        enable(id + ' :input', isEnabled);
        if (isEnabled) {
            $('#url').focus();
        }
    }

    function enable(selector, enabled) {
        if (enabled) {
            $(selector).removeAttr('disabled');
            $(selector).removeClass('disabled');
        } else {
            $(selector).attr('disabled', 'true');
            $(selector).addClass('disabled');
        }
    }

});
