define('page/plugin/svn-import-configure', ['exports', 'jquery', '@atlassian/aui'], function(exports, $, AJS) {
    exports.onReady = function() {
        AJS.$('#save-button').click(function(e) {
            e.preventDefault();
            AJS.$('#save-button').prop('disabled', true);
            AJS.$.ajax({
                type : 'POST',
                url : '',
                async : true,
                data : AJS.$('#settings-form').serialize(),                
                success : function(data) {
                    AJS.$('#save-button').prop('disabled', false);
                    AJS.$('#aui-message-bar').empty();
                    AJS.messages.success({
                        title: 'Success',
                        body: 'Add-on settings has been updated.'
                        });
                },
                error : function(data) {
                    AJS.$('#save-button').prop('disabled', false);
                    AJS.$('#aui-message-bar').empty();
                    AJS.messages.error({
                        title: 'Error',
                        body: 'Add-on settings has not been updated.' 
                        });
                }
            });
            return false;
        });

        var authorsFile = null;
        AJS.$('#authorsFileChooser').change(function(event) {
            if (event.target.files[0]) {
                authorsFile = event.target.files[0];
                AJS.$('#upload-button').prop('disabled', false);
            }
        });
        AJS.$('#upload-button').click(function(e) {
            e.preventDefault();
            AJS.$('#upload-button').prop('disabled', true);
            var mergeStrategy = AJS.$('input[type=radio]:checked', '#authors-form').val();
            
            var xhr = new XMLHttpRequest();
            xhr.open('POST', document.URL + '/authors.txt?merge=' + mergeStrategy);
            xhr.onreadystatechange = function(e) {
                if (this.readyState == 4) {
                    AJS.$('#upload-button').prop('disabled', false);
                    AJS.$('#aui-authors-message-bar').empty();
                    if (this.status == 200) {
                        AJS.$('#mapping-description').html(this.response);
                        AJS.messages.success('#aui-authors-message-bar', {
                            title: 'Success',
                            body: 'Authors mapping has been uploaded.'
                            });
                    }  else {
                        AJS.messages.error('#aui-authors-message-bar', {
                            title: 'Error',
                            body: 'Authors mapping has not been uploaded.' 
                            });
                    }
                }
            };
            xhr.send(authorsFile);
            return false;
        });

        AJS.$('#upload-button').prop('disabled', true);        
    };
});
