define('tmatesoft/svn/views/util', [
    '@atlassian/aui',
    'exports'
], function(
    AJS,
    exports
) {

    var createDialog = function(el, $, type, title, content, buttons, okCb) {
        $(el).empty();

        var template = tmatesoft.svn.dialog({
            type : type,
            title : title,
            content : content,
            buttons : buttons
        });

        $(el).append(template);

        var dialogElement = $('.modal-dialog')[0];
        return AJS.dialog2(dialogElement);
    };

    var trackFieldChanges = function($el, $, cb) {
        if ($el.is(':checkbox') || $el.is(':radio') || $el.is('select')) {
            $el.change(function() {
                if ($(this).is(':radio')) {
                    $('#' + $(this).attr('name') + ' input[type="radio"]').each(function() {
                        cb.call(this, $(this).is(':checked'));
                    });
                } else if ($(this).is(':checkbox')) {
                    cb.call(this, $(this).is(':checked'));
                } else {
                    cb.call(this, $(this).val());
                }
            });
        } else if ($el.is(':text')
            || $el.is('textarea')
            || $el.is('input[type="url"]')
            || $el.is('input[type="password"]')) {
            $el.mouseup(function() {
                var oldValue = $(this).val();
                if (oldValue == '') {
                    return;
                }
                var el = this;
                window.setTimeout(function() {
                    cb.call(el, $(el).val());
                }, 1);
            });

            $el.bind('change paste keyup', function() {
                cb.call(this, $(this).val());
            });

            if (!$el.is('textarea')) {
                $el.on('focus', function() {
                    var field = $(this)
                        .one('mouseup.mouseupSelect', function() {
                            field.select();
                            return false;
                        })
                        .one('mousedown', function() {
                            field.off('mouseup.mouseupSelect');
                        })
                        .select();
                });
            }

            $el.attr('spellcheck', 'false');
        }

    };

    var sanitizeText = function(val) {
        if (!val) {
            return val;
        }
        val = val.replace('/(?:\r\n|\r)/g', '\n');
        val = val.replace('/(?:\t)/g', '    ');
        val = val.trim();
        return val;
    };

    exports.trackFieldChanges = trackFieldChanges;
    exports.createDialog = createDialog;
    exports.sanitizeText = sanitizeText;

});
