define('tmatesoft/svn/views/unsynced/unsynced-table', [
    'tmatesoft/svn/views/list-view',
    'tmatesoft/svn/views/unsynced/unsynced-item-provider',
    'tmatesoft/svn/views/unsynced/unsynced-item'
], function(
    ListView,
    UnsyncedItemProvider,
    UnsyncedItem
) {

    'use strict';

    function UnsyncedTable(commandTracker) {
        this.commandTracker = commandTracker;
    };

    UnsyncedTable.prototype.children = function() {
        var commandTracker = this.commandTracker;
        return {
            'tbody' : function(model, el, $) {
                var listViewOptions = {
                    itemProvider : new UnsyncedItemProvider(),
                    tagName : 'tr',
                    attrName : 'data-unsynced-id',
                    itemViewFactory : function(model, el, $) {
                        var unsyncedId = el.getAttribute('data-unsynced-id');
                        var item = model.get('data.unsyncedRefs')[unsyncedId];
                        return new UnsyncedItem(item, commandTracker);
                    }
                };
                return new ListView(listViewOptions);
            }
        };
    };

    UnsyncedTable.prototype.render = function(model, el, $) {
        el.innerHTML = tmatesoft.svn.unsyncedTable();
    };

    UnsyncedTable.prototype.update = function(event, el, $) {
        return event.changed('data.unsyncedRefs');
    };

    return UnsyncedTable;
});