define('tmatesoft/svn/views/unsynced/unsynced-item', [
    '@atlassian/aui',
    'bitbucket/util/navbuilder',
    'bitbucket/util/state',
    'tmatesoft/engine-util',
    'tmatesoft/svn/views/util',
    'tmatesoft/svn/views/status-util',
    'tmatesoft/svn/messages'
], function(
    AJS,
    nav,
    pageState,
    Util,
    ViewUtil,
    StatusUtil,
    Messages
) {
    'use strict';

    function UnsyncedItem(item, commandTracker) {
        this.commandTracker = commandTracker;
        this.item = item;
    };

    UnsyncedItem.prototype.render = function(model, el, $) {
        var commitLink = nav.project(pageState.getProject().key).repo(pageState.getRepository().slug).commit(this.item.commitId).build();
        el.innerHTML = tmatesoft.svn.unsyncedItemRow({
            item : this.item,
            commitLink : commitLink
        });
    };

    UnsyncedItem.prototype.setup = function(model, el, $) {
        var self = this;

        $('.ref-remove').click(function() {
            var commandName = $(this).attr('data-command');
            var commandItem = Util.clone(self.item);
            var commandData = Util.clone(model.get());
            commandData.data.unsyncedRefsCommands = [ commandItem ];
            self.commandTracker.sendCommand(commandName, commandData);
        });

        $('.ref-action').click(function() {
            var commandName = $(this).attr('data-command');
            if (commandName === 'unsynced-merge') {
                self.showMergeDialog($);
            } else {
                var commandItem = Util.clone(self.item);
                var commandData = Util.clone(model.get());
                commandData.data.unsyncedRefsCommands = [ commandItem ];
                self.commandTracker.sendCommand(commandName, commandData);
            }
        });

        var scopeId = model.get('scope.id');
        this.commandListener = this.commandTracker.on('send completed cancelled', scopeId,
            function() {
                var disabled = self.commandTracker.isCommandSubmitted(scopeId);
                $('.ref-remove,.ref-action').prop('disabled', disabled);
            }
        );
    };

    UnsyncedItem.prototype.showMergeDialog = function($) {
        var dialog = ViewUtil.createDialog($('.merge-dialog')[0], $, 'confirmation',
            'Merge',
              '<p>To merge unsynced commits back to repository, you may run '
            + 'the following commands:</p>'
            + '<pre>'
            + '$ git clone GIT_REPOS_URL project\n'
            + '$ cd project\n'
            + '$ git checkout <strong>' + this.item.targetRef + '</strong>\n'
            + '$ git fetch origin <strong>' + this.item.ref + '</strong>:<strong>' + this.item.ref + '</strong>\n'
            + '$ git merge <strong>' + this.item.ref + '</strong>\n'
            + '$ git push\n'
            + '</pre>'
            ,
            [
            {
                id : 'close-button',
                label : 'Close'
            },
            ]
        );
        $('#close-button').click(function() {
            dialog.hide();
        });

        dialog.show();
    };

    return UnsyncedItem;
});
