define('tmatesoft/svn/views/unsynced/unsynced-item-provider', [], function() {
    'use strict';

    function UnsyncedItemProvider() {};

    UnsyncedItemProvider.prototype.getItems = function(model) {
        var result = [];
        var items = model.get('data.unsyncedRefs');
        if (items) {
            for(var i = 0; i < items.length; i++) {
                result.push(i);
            }
        }
        return result;
    };

    UnsyncedItemProvider.prototype.compare = function(model, id1, id2) {
        var items = model.get('data.unsyncedRefs');
        var item1 = items[id1];
        var item2 = items[id2];

        var refName1 = item1.targetRef;
        var refName2 = item2.targetRef;
        if (refName1 !== refName2) {
            return refName1 > refName2 ? 1 : -1;
        }
        return 0;
    };

    UnsyncedItemProvider.prototype.update = function(event) {
        var delta = {};
        var items = event.get('data.unsyncedRefs');
        var self = this;

        event.changed('data.unsyncedRefs', function(previous, current) {
            if (previous) {
                delta.removed = [];
                for(var i = 0; i < previous.length; i++) {
                    delta.removed.push(i);
                }
            }
            delta.added = self.getItems(event);
        });

        return delta;
    };

    return UnsyncedItemProvider;
});