define('tmatesoft/svn/views/tabs-view', [
    '@atlassian/aui',
    'tmatesoft/svn/views/repository-table',
    'tmatesoft/svn/views/buttons-view',
    'tmatesoft/svn/views/stagemat-view',
    'tmatesoft/svn/views/unsynced/unsynced-table',
    'tmatesoft/svn/views/settings/global-settings',
    'tmatesoft/svn/views/settings/credentials-settings',
    'tmatesoft/svn/views/settings/layout-settings',
    'tmatesoft/svn/views/settings/authors-mapping-settings',
    'tmatesoft/svn/views/settings/sync-settings',
    'tmatesoft/svn/views/settings/translation-settings',
    'tmatesoft/svn/views/settings/url-settings',
    'tmatesoft/svn/views/settings/authors-editor',
    'tmatesoft/svn/views/settings/config-editor',
    'tmatesoft/svn/views/settings/verify-info',
    'tmatesoft/svn/views/settings/support-zip-settings',
    'tmatesoft/svn/views/settings/rebuild-settings'
], function(
    AJS,
    RepositoryTable,
    ButtonsView,
    StageMatView,
    UnsyncedTable,
    GlobalSettings,
    CredentialsSettings,
    LayoutSettings,
    AuthorsMappingSettings,
    SyncSettings,
    TranslationSettings,
    UrlSettings,
    AuthorsEditor,
    ConfigEditor,
    VerifyInfo,
    SupportZipView,
    RebuildView
) {
    'use strict';

    function TabsView(commandTracker) {
        this.commandTracker = commandTracker;
    };

    TabsView.prototype.children = function() {
        var commandTracker = this.commandTracker;
        return {
            '.global-settings-tab' : function(model, el, $) {
                return new GlobalSettings();
            },
            '.repositories-tab' : function(model, el, $) {
                return new RepositoryTable(commandTracker);
            },
            '.authors-editor-tab' : function(model, el, $) {
                return new AuthorsEditor();
            },
            '.config-editor-tab' : function(model, el, $) {
                return new ConfigEditor();
            },
            '.authors-mapping-tab' : function(model, el, $) {
                return new AuthorsMappingSettings();
            },
            '.credentials-tab' : function(model, el, $) {
                return new CredentialsSettings(commandTracker);
            },
            '.url-tab' : function(model, el, $) {
                return new UrlSettings();
            },
            '.layout-tab' : function(model, el, $) {
                return new LayoutSettings();
            },
            '.sync-tab' : function(model, el, $) {
                return new SyncSettings();
            },
            '.translation-tab' : function(model, el, $) {
                return new TranslationSettings();
            },
            '.unsynced-tab' : function(model, el, $) {
                return new UnsyncedTable(commandTracker);
            },
            '.rebuild-tab' : function(model, el, $) {
                return new VerifyInfo(commandTracker);
            },
            '.support-zip-view' : function(model, el, $) {
                return new SupportZipView(commandTracker);
            },
            '.rebuild-view' : function(model, el, $) {
                return new RebuildView(commandTracker);
            },
            '.stagemat-view' : function(model, el, $) {
                return new StageMatView(commandTracker);
            },
            '.buttons-view' : function(model, el, $) {
                return new ButtonsView(commandTracker);
            }
        };
    };

    TabsView.prototype.render = function(model, el, $) {
        var stage = model.get('data.stage');
        var onMesh = model.get('data.onMesh');
        var html = tmatesoft.svn.tabsView({stage : stage, onMesh: onMesh});
        if (html !== '') {
            el.innerHTML = html;
        }
    };

    TabsView.prototype.postRender = function(model, el, $) {
        $('form').submit(function() { return false; });
        if ($('.tabs-pane').length === 0) {
            return;
        }

        AJS.tabs.setup();
        var self = this;
        this.updateTabsHeight(model, el, $);
        $('.tabs-menu a').bind('tabSelect', function() {
            self.updateTabsVisibility(model, $);
        });
        this.selectChosenTab(model, $);
        this.updateTabsVisibility(model, $);
    };

    TabsView.prototype.updateTabsHeight = function(model, el, $) {
        var tabMaxMatchingHeight = 0;
        var self = this;
        $('.tabs-pane').each(function() {
            AJS.tabs.change($('a[href="#' + this.id + '"]'));
            if (self.shouldMatchHeight(this.id)) {
                tabMaxMatchingHeight = Math.max(tabMaxMatchingHeight, $(this).outerHeight(true));
            }
        });
        var buttonsHeight = $('.buttons-view').outerHeight();
        if (tabMaxMatchingHeight > 0) {
            $('.tabs-pane').each(function() {
                if (self.shouldMatchHeight(this.id)) {
                    $(this).outerHeight(tabMaxMatchingHeight);
                }
            });
        }
    };

    TabsView.prototype.update = function(event, el, $) {
        var self = this;
        var stage = event.get('data.stage');

        event.changed('data.hasUnsyncedRefs', function(previous, current) {
            self.updateTabsVisibility(event.model, $);
        });
        event.changed('data.verifyInfo', function(previous, current) {
            self.updateTabsVisibility(event.model, $);
        });
        return event.changed('data.stage', function(previous, current) {
            if (!previous) {
                return true;
            } if (current === 'INITIAL'
                || current === 'PENDING_METADATA_MOVE'
                || current === 'NO_LICENSE'
                || current === 'INCOMPATIBLE'
                || current === 'EXTERNAL_REMOTE'
                || current === 'EXTERNAL_LOCAL'
                || current === 'LEGACY'
                || current === 'UNKNOWN') {
                return true;
            } else if (previous !== 'INSTALLED' && previous !== 'PAUSED') {
                return true;
            }
            self.updateTabsVisibility(event.model, $);
        });
    };

    TabsView.prototype.selectChosenTab = function(model, $) {
        if (window.location.hash && window.location.hash.length > 0) {
            var chosen = window.location.hash.substring(1);
            if (chosen === 'authors' || chosen === 'authors-tab') {
                AJS.tabs.change($('a[href="#authors-editor-tab"]'));
                return;
            } else if (chosen === 'unsynced' || chosen === 'unsynced-tab') {
                if (this.isUnsyncedVisible(model)) {
                    AJS.tabs.change($('a[href="#unsynced-tab"]'));
                    return;
                }
            } else if (chosen === 'rebuild' || chosen === 'rebuild-tab') {
                if (this.isRebuildVisible(model)) {
                    AJS.tabs.change($('a[href="#rebuild-tab"]'));
                    return;
                }
            } else if (chosen === 'issues' || chosen === 'issues-tab') {
                AJS.tabs.change($('a[href="#issues-tab"]'));
                return;
            } else if (chosen === 'support' || chosen === 'support-tab') {
                AJS.tabs.change($('a[href="#support-tab"]'));
                return;
            }
        }

        if (this.isRebuildVisible(model)) {
            AJS.tabs.change($('a[href="#rebuild-tab"]'));
            return;
        }

        var stage = model.get('data.stage');
        if (stage === 'GLOBAL' || stage === 'PROJECT') {
            AJS.tabs.change($('a[href="#repositories-tab"]'));
        } else if (stage !== 'INITIAL') {
            AJS.tabs.change($('a[href="#config-editor-tab"]'));
        }
    };

    TabsView.prototype.updateTabsVisibility = function(model, $) {
        $('.buttons-view').toggle(this.shouldMatchHeight($('.active-pane').attr('id')));
        if (!this.isUnsyncedVisible(model)) {
            if ($('.unsynced-tab-header').hasClass('active-tab')) {
                AJS.tabs.change($('a[href="#authors-editor-tab"]'));
            }
            $('.unsynced-tab-header').toggle(false);
        } else {
            $('.unsynced-tab-header').toggle(true);
        }

        if (!this.isRebuildVisible(model)) {
            if ($('.rebuild-tab-header').hasClass('active-tab')) {
                AJS.tabs.change($('a[href="#authors-editor-tab"]'));
            }
            $('.rebuild-tab-header').toggle(false);
        } else {
            $('.rebuild-tab-header').toggle(true);
        }
    };

    TabsView.prototype.shouldMatchHeight = function(id) {
        return !(id === 'repositories-tab'
            || id === 'unsynced-tab'
            || id === 'rebuild-tab'
            || id === 'issues-tab'
            || id === 'support-tab');
    };

    TabsView.prototype.isUnsyncedVisible = function(model) {
        var stage = model.get('data.stage');
        return (stage === 'INSTALLED' || stage === 'PAUSED') && model.get('data.hasUnsyncedRefs');
    };

    TabsView.prototype.isRebuildVisible = function(model) {
        var stage = model.get('data.stage');
        if (stage === 'INSTALLED' || stage === 'PAUSED') {
            var verifyInfo = model.get('data.verifyInfo');
            return verifyInfo !== null && verifyInfo.issues.length > 0;
        }
        return false;
    };


    return TabsView;
});
