define('tmatesoft/svn/views/status-util', [
    'exports',
    'tmatesoft/svn/messages'
], function(
    exports,
    Messages
) {
    'use strict';

    var updatePrimaryBadge = function(item, $, isLink, url) {
        var data = Messages.getPrimaryBadgeData(item, isLink);
        $('.primary-badge')
            .removeClass()
            .addClass('primary-badge aui-lozenge aui-lozenge-' + data[0])
            .text(data[1])
            .attr('title', data[2]);
        if (isLink && url) {
            $('.primary-badge-container').attr('href', url);
        }
    };

    var updateSecondaryBadge = function(item, $, isLink, url) {
        var data = Messages.getSecondaryBadgeData(item, isLink);
        $('.secondary-badge-container').toggle(data !== null);
        if (data) {
            $('.secondary-badge')
                .removeClass()
                .addClass('secondary-badge aui-lozenge aui-lozenge-' + data[0])
                .text(data[1])
                .attr('title', data[2]);
            if (isLink && url) {
                if (item.data.hasUnsyncedRefs) {
                    $('.secondary-badge-container').attr('href', url + '#unsynced');
                } else {
                    $('.secondary-badge-container').attr('href', url);
                }
            }
        }
    };

    var updateMessage = function(item, $) {
        var statusData = Messages.getStatusData(item);
        $('.message').text(statusData.message);
        if (statusData.percentage >= 0) {
            $('.bar').css('width', statusData.percentage + '%');
        }
        $('.progress-container').toggle(statusData.percentage >= 0);
    };

    var getCommandForStage = function(item) {
        var stage = item.data.stage;

        if (stage === 'PAUSED') {
            if (item.data.importRequested) {
                return { name : 'start-import', label : 'Resume Import', title : 'Resume Import from Subversion' };
            } else {
                return { name : 'start', label : 'Enable', title : 'Enable Synchronization' };
            }
        } else if (stage == 'INSTALLED') {
            if (item.data.importRequested) {
                return { name : 'stop-import', label : 'Stop', title : 'Stop Import' };
            } else {
                return { name : 'stop', label : 'Disable', title : 'Disable Synchronization' };
            }
        } else if (stage == 'LEGACY') {
            return { name : 'upgrade', label : 'Upgrade', title : 'Upgrade Mirror' };
        } else if (stage === 'PENDING_METADATA_MOVE') {
            return { name : 'move-metadata', label : 'Upgrade', title : 'Upgrade Metadata' };
        } else if (stage == 'EXTERNAL_LOCAL' || stage == 'EXTERNAL_REMOTE') {
            return {name : 'refresh', label : 'Refresh', title : 'Refresh Bitbucket Branches and Tags' };
        } else if (stage == 'UNKNOWN') {
            return {name : 'reset', label : 'Reset', title : 'Reset Mirror State' };
        } else if (stage == 'NO_LICENSE') {
            return {name : 'license', label : 'Get License', title : 'Get License for SVN Mirror Add-on' };
        } else if (stage == 'INCOMPATIBLE') {
            return {name : 'support', label : 'Create Support Zip', title : 'Collect SVN Mirror Add-on Support Zip Archive' };
        }
        return {name : 'unknown', label : 'Not Available' };
    };

    exports.updatePrimaryBadge = updatePrimaryBadge;
    exports.updateSecondaryBadge = updateSecondaryBadge;
    exports.updateMessage = updateMessage;
    exports.getCommandForStage = getCommandForStage;
});