define('tmatesoft/svn/views/stagemat-view', [
    'bitbucket/util/navbuilder',
    'tmatesoft/svn/views/status-util'
], function(
    nav,
    StatusUtil
) {
    'use strict';

    function StageMatView(commandTracker) {
        this.commandTracker = commandTracker;
    };

    StageMatView.prototype.render = function(model, el, $) {
        var stage = model.get('data.stage');
        if (stage === 'LEGACY') {
            el.innerHTML = tmatesoft.svn.legacyStageMat();
        } else if (stage === 'PENDING_METADATA_MOVE') {
            el.innerHTML = tmatesoft.svn.pendingMetadataMoveStageMat();
        } else if (stage === 'NO_LICENSE') {
            el.innerHTML = tmatesoft.svn.licenseStageMat();
        } else if (stage === 'INCOMPATIBLE') {
            el.innerHTML = tmatesoft.svn.incompatibleStageMat();
        } else if (stage === 'EXTERNAL_REMOTE' || stage === 'EXTERNAL_LOCAL') {
            el.innerHTML = tmatesoft.svn.externalStageMat();
        } else if (stage === 'UNKNOWN') {
            el.innerHTML = tmatesoft.svn.unknownStageMat();
        }
    };

    StageMatView.prototype.setup = function(model, el, $) {
        var self = this;
        var command = StatusUtil.getCommandForStage(model.get());
        $('#mat-button').attr('data-command', command.name).text(command.label).attr('title', command.title);
        $('#mat-button').click(function() {
            var commandName = $(this).attr('data-command');
            if (commandName !== 'license' && commandName !== 'support') {
                self.commandTracker.sendCommand(commandName, model.get());
            } else if (commandName === 'license') {
                var targetUrl = nav.pluginServlets().path('upm').withFragment('manage/org.tmatesoft.subgit.stash-svn-importer').build();
                window.location.href = targetUrl;
            } else if (commandName === 'support') {
                var targetUrl = nav.pluginServlets().path('svn').withFragment('support-tab').build();
                window.location.href = targetUrl;
            }
        });

        var scopeId = model.get('scope.id');
        this.commandListener = this.commandTracker.on('sent completed cancelled', scopeId, function() {
            $('#mat-button').prop('disabled', self.commandTracker.isCommandSubmitted(scopeId));
        });
    };

    StageMatView.prototype.dispose = function(event, el, $) {
        this.commandTracker.off(this.commandListener);
        this.commandListener = null;
    };

    return StageMatView;
});