define('tmatesoft/svn/views/settings/verify-info', [
    'tmatesoft/svn/views/util'
], function(
    Util
) {
    'use strict';

    function VerifyInfo(tracker) {
        this.dataPath = 'data.verifyInfo';
        this.commandTracker = tracker;
    };

    VerifyInfo.prototype.render = function(model, el, $) {
        var info = model.get(this.dataPath);
        var html = '';
        html += tmatesoft.svn.settings.verifyInfo({info: info});
        el.innerHTML = html;
    };

    VerifyInfo.prototype.setup = function(model, el, $) {
        var self = this;

        $('#rebuild-button').click(function(e) {
            e.preventDefault();
            self.commandTracker.sendCommand('rebuild', model.get());
        });
    };

    VerifyInfo.prototype.update = function(event, el, $) {
        return event.changed(this.dataPath);
    };

    return VerifyInfo;
});