define('tmatesoft/svn/views/settings/url-settings', [
    'tmatesoft/svn/validation',
    'tmatesoft/svn/views/util'
], function(
    Validation,
    Util
) {

    'use strict';

    function UrlSettings() {
    };

    UrlSettings.prototype.render = function(model, el, $) {
        var html = '';
        html += tmatesoft.svn.settings.url();
        el.innerHTML = html;
    };

    UrlSettings.prototype.setup = function(model, el, $) {
        Util.trackFieldChanges($('#url'), $, function(val) {
            model.set('data.url', val, this);
        });
        var url = model.get('data.url');
        this.updateUrlBadge(url, el, $);
        $('#url').val(url);

        if (model.get('data.stage') === 'INITIAL') {
            $('#url').focus();
        }
    };

    UrlSettings.prototype.update = function(event, el, $) {
        var self = this;
        event.changed('data.url', function(previous, current) {
            $('#url').val(current);
            self.updateUrlBadge(current, el, $);
        });
    };

    UrlSettings.prototype.updateUrlBadge = function(url, el, $) {
        var clazz = 'url-badge aui-icon aui-icon-small ';
        var title;
        if (!Validation.isUrlValid(url)) {
            clazz += 'aui-iconfont-error';
            title = 'Enter valid URL';
        } else {
            clazz += 'aui-iconfont-approve';
            title = 'URL is valid';
        }
        $('.url-badge').removeClass().addClass(clazz).attr('title', title);
    };

    return UrlSettings;
});