define('tmatesoft/svn/views/settings/translation-settings', [
    'tmatesoft/svn/views/util'
], function(
    Util
) {

    'use strict';

    function TranslationSettings() {
    };

    TranslationSettings.prototype.render = function(model, el, $) {
        var html = '';
        html += tmatesoft.svn.settings.translation();
        el.innerHTML = html;
    };

    TranslationSettings.prototype.setup = function(model, el, $) {
        Util.trackFieldChanges($('#minimal-revision'), $, function(val) {
            model.set('data.minimalRevision', parseInt(val, 10), this);
        });
        Util.trackFieldChanges($('#translate-eols'), $, function(val) {
            model.set('data.eols', val, this);
        });
        Util.trackFieldChanges($('#translate-ignores'), $, function(val) {
            model.set('data.ignores', val, this);
        });
        $('#minimal-revision').val(model.get('data.minimalRevision'));
        $('#translate-eols').prop('checked', model.get('data.eols'));
        $('#translate-ignores').prop('checked', model.get('data.ignores'));

        $('input').prop('disabled', model.get('data.stage') !== 'CONFIGURED');
    };

    TranslationSettings.prototype.update = function(event, el, $) {
        var self = this;
        event.changed('data.minimalRevision', function(previous, current) {
            $('#minimal-revision').val(!isNaN(current) ? current : '');
        });
        event.changed('data.eols', function(previous, current) {
            $('#translate-eols').prop('checked', current);
        });
        event.changed('data.ignores', function(previous, current) {
            $('#translate-ignores').prop('checked', current);
        });
        if (event.changed('data.stage'), function(previous, current) {
            $('input').prop('disabled', current !== 'CONFIGURED');
        });
    };

    return TranslationSettings;
});