define('tmatesoft/svn/views/settings/sync-settings', [
    'tmatesoft/svn/views/util'
], function(
    Util
) {

    'use strict';

    function SyncSettings() {
    };

    SyncSettings.prototype.render = function(model, el, $) {
        var html = '';
        html += tmatesoft.svn.settings.sync();
        el.innerHTML = html;
    };

    SyncSettings.prototype.setup = function(model, el, $) {
        Util.trackFieldChanges($('#fetch-interval'), $, function(val) {
            model.set('data.fetchInterval', parseInt(val, 10), this);
        });
        var interval = model.get('data.fetchInterval');
        $('#fetch-interval').val(interval);
    };

    SyncSettings.prototype.update = function(event, el, $) {
        var self = this;
        event.changed('data.fetchInterval', function(previous, current) {
            $('#fetch-interval').val(!isNaN(current) ? current : '');
        });
    };

    return SyncSettings;
});