define('tmatesoft/svn/views/settings/support-zip-settings', [
    'bitbucket/util/navbuilder',
    'tmatesoft/engine-util',
    'tmatesoft/svn/messages'
], function(
    nav,
    Util,
    Messages
) {

    'use strict';

    function SupportSettings(commandTracker) {
        this.commandTracker = commandTracker;
    };

    SupportSettings.prototype.render = function(model, el, $) {
        var supportZipUrl = nav.pluginServlets().path('troubleshooting').build();
        supportZipUrl += '/view#support-zip';
        var html = '';
        html += tmatesoft.svn.settings.supportZip({
          scope : model.get('scope'),
          user : model.get('user'),
          bitbucketSupportZipUrl : supportZipUrl
        });
        el.innerHTML = html;
    };

    SupportSettings.prototype.setup = function(model, el, $) {
        var self = this;
        this.updateSupportZip(model, el, $);

        $('#support-zip-button').click(function() {
            var request = {
              includeServerLogs : $('#support-zip-include-server-logs').is(':checked'),
              includeGlobalLogs : $('#support-zip-include-svnmirror-logs').is(':checked'),
              includeGlobalAuthorsMapping : true,
              scope : Util.clone(model.get('scope')),
              data : Util.clone(model.get('data'))
            };
            self.commandTracker.sendCommand('build-support-zip', request, true);
        });
        $('#support-remove-zips-button').click(function() {
            self.commandTracker.sendCommand('remove-support-zips', Util.clone(model.get()), true);
        });

    };

    SupportSettings.prototype.update = function(event, el, $) {
        if (event.changed('data.supportZips')) {
            this.updateSupportZip(event, el, $);
        }
    };

    SupportSettings.prototype.updateSupportZip = function(model, el, $) {
        var zips = model.get('data.supportZips');

        if (zips && Util.isArray(zips) && zips.length > 0) {
            $('#last-support-zip-present').empty();
            var repositoryId = model.get('scope.repositoryId');
            for(var i = 0; i < zips.length; i++) {
                var zip = Util.clone(zips[i]);
                zip.displayTime = Messages.formatDateAndTime(zip.time);
                zip.displaySize = Messages.formatFileSize(zip.size);
                zip.url = window.location.pathname + '/support/' + zip.name;

                var html = tmatesoft.svn.settings.supportZipEntry({zip : zip});
                $('#last-support-zip-present').append(html);
            }

            $('#last-support-zip-present').show();
            $('#last-support-zip-missing').hide();

            $('#support-zip-button').text('Create Another Zip');
            $('#support-remove-zips-button').toggle(zips.length > 0);
        } else {
            $('#last-support-zip-present').hide();
            $('#last-support-zip-missing').show();
            $('#support-zip-button').text('Create Zip');
            $('#support-remove-zips-button').toggle(false);
        }
    };

    return SupportSettings;
});