define('tmatesoft/svn/views/settings/rebuild-settings', [
    'tmatesoft/svn/validation',
    'tmatesoft/svn/views/util',
    'tmatesoft/engine-util'
], function(
    Validation,
    ViewUtil,
    Util
) {

    'use strict';

    function RebuildSettings(commandTracker) {
        this.commandTracker = commandTracker;
    };

    RebuildSettings.prototype.render = function(model, el, $) {
        var html = '';
        html += tmatesoft.svn.settings.rebuildFromRevision();
        el.innerHTML = html;
    };

    var rebuildRevisionModified = false;

    RebuildSettings.prototype.setup = function(model, el, $) {
        var self = this;

        this.setRebuildFromRevision(model, el, $);
        this.updateRebuildFromRevision(model, el, $);
        ViewUtil.trackFieldChanges($('#rebuild-from-revision'), $, function(val) {
            rebuildRevisionModified = true;
            self.updateRebuildFromRevision(model, el, $);
        });

        $('#rebuild-from-revision-button').click(function() {
            var revision = parseInt($('#rebuild-from-revision').val());
            var data = Util.clone(model.get());
            data.data.verifyInfo.rebuildRevision = revision;
            self.commandTracker.sendCommand('rebuild', data);
        });
    };

    RebuildSettings.prototype.update = function(event, el, $) {
        if (event.changed('data.stage') || event.changed('data.minimalRevision')) {
            this.updateRebuildFromRevision(event, el, $);
        }
    };
    RebuildSettings.prototype.setRebuildFromRevision = function(model, el, $) {
        if (!rebuildRevisionModified) {
            var minimalRevision = model.get('data.minimalRevision');
            if (Validation.isMinimalRevisionValid(minimalRevision)) {
                $('#rebuild-from-revision').val(minimalRevision);
            } else {
                $('#rebuild-from-revision').val('');
            }
        }
    };
    RebuildSettings.prototype.updateRebuildFromRevision = function(model, el, $) {
        var stage = model.get('data.stage');
        var enabled = (stage == 'INSTALLED' || stage == 'PAUSED');
        var buttonEnabled = false;
        this.setRebuildFromRevision(model, el, $);
        if (enabled) {
            var revision = $('#rebuild-from-revision').val();
            buttonEnabled = Validation.isRebuildRevisionValid(revision, model.get('data.minimalRevision'));
        }
        $('#rebuild-from-revision').prop('disabled', !enabled);
        $('#rebuild-from-revision-button').prop('disabled', !buttonEnabled);
    };

    return RebuildSettings;
});