define('tmatesoft/svn/views/settings/layout-settings', [
    'tmatesoft/svnmirror/util/tree-dialog',
    'tmatesoft/svn/validation',
    'tmatesoft/svn/views/util'
], function(
    tree,
    Validation,
    Util
) {

    'use strict';

    function LayoutSettings() {
    };

    LayoutSettings.prototype.render = function(model, el, $) {
        var html = '';
        html += tmatesoft.svn.settings.layout();
        el.innerHTML = html;
    };

    LayoutSettings.prototype.setup = function(model, el, $) {
        var self = this;
        this.trunkPathUrl = model.get('data.url');
        $('#trunkPath-button').click(function(e) {
            e.preventDefault();
            tree.show('#trunk-dialog',
                svnmirror.trunkDialog(),
                '?command=get-subversion-tree',
                model.get(),
                function(path) {
                    self.trunkPathUrl = model.get('data.url');
                    model.set('data.trunkPath', path);
                });
            return false;
        });
        Util.trackFieldChanges($('#autoLayout'), $, function(val) {
            if (val) {
                model.set('data.layoutType', 'AUTO', this);
            }
        });
        Util.trackFieldChanges($('#manualLayout'), $, function(val) {
            if (val) {
                model.set('data.layoutType', 'MANUAL', this);
            }
        });
        Util.trackFieldChanges($('#singleDirectory'), $, function(val) {
            if (val) {
                model.set('data.layoutType', 'DIRECTORY', this);
            }
        });
        this.updateTrunkPathValue(model, el, $);
        this.updateLayoutSelector(model, el, $);
    };

    LayoutSettings.prototype.update = function(event, el, $) {
        var self = this;
        event.changed('data.trunkPath', function(previous, current) {
            self.updateTrunkPathValue(event.model, el, $);
        });
        event.changed('data.url', function(previous, current) {
            self.updateTrunkPathValue(event.model, el, $);
        });
        event.changed('data.credentials', function(previous, current) {
            self.updateTrunkPathValue(event.model, el, $);
        });
        event.changed('data.layoutType', function(previous, current) {
            self.updateTrunkPathValue(event.model, el, $);
            self.updateLayoutSelector(event.model, el, $);
        });
    };

    LayoutSettings.prototype.updateTrunkPathValue = function(model, el, $) {
        var data = model.get('data');
        $('.trunkPath').text(data.trunkPath || '<not chosen>');
        var layoutType = data.layoutType || 'AUTO';
        var isEnabled = layoutType === 'AUTO'
            && Validation.isCredentialsValid(data.credentials)
            && Validation.isUrlValid(data.url);
        $('#trunkPath-button').prop('disabled', !isEnabled);
        $('.trunkPath').attr('disabled', !isEnabled);

        var clazz = 'trunkPath-badge aui-icon aui-icon-small ';
        var title = '';

        var shouldBeEnabled = layoutType === 'AUTO';
        if (shouldBeEnabled) {
            if (!data.trunkPath && !Validation.isUrlValid(data.url)) {
                clazz += 'aui-iconfont-error';
                title = 'Enter valid URL above,\nthen choose trunk path';
            } else if (!data.trunkPath && !Validation.isCredentialsValid(data.credentials)) {
                clazz += 'aui-iconfont-error';
                title = 'Enter valid credentials,\nthen choose trunk path';
            } else if (data.url && data.url !== this.trunkPathUrl && data.trunkPath) {
                clazz += 'aui-iconfont-warning';
                title = 'URL has changed since trunk path has been selected';
            } else if (!data.trunkPath) {
                clazz += 'aui-iconfont-error';
                title = 'Trunk path is required for automatic configuration';
            }
        }
        $('.trunkPath-badge').removeClass().addClass(clazz).attr('title', title);
    };

    LayoutSettings.prototype.updateLayoutSelector = function(model, el, $) {
        var layoutType = model.get('data.layoutType') || 'AUTO';

        $('#autoLayout').prop('checked', layoutType === 'AUTO');
        $('#manualLayout').prop('checked', layoutType === 'MANUAL');
        $('#singleDirectory').prop('checked', layoutType === 'DIRECTORY');
    }

    return LayoutSettings;
});