define('tmatesoft/svn/views/settings/global-settings', [
    'tmatesoft/svn/views/util'
], function(
    Util
) {

    'use strict';

    function GlobalSettings() {
    };

    GlobalSettings.prototype.render = function(model, el, $) {
        var html = '';
        html += tmatesoft.svn.settings.authorisation();
        html += tmatesoft.svn.settings.backend();
        html += tmatesoft.svn.settings.performance();
        html += tmatesoft.svn.settings.polling();
        html += tmatesoft.svn.settings.logLevel();
        el.innerHTML = html;
    };

    GlobalSettings.prototype.setup = function(model, el, $) {
        var runnersCount = model.get('data.schedulerOptions.maxRunnersCount', 10);

        this.updateRunnersCount(runnersCount, el, $);
        this.updateLongPollOptions(model.get('data.longPollOptions'), el, $);
        this.updateDebugLevelOption(model.get('data.logLevel'), el, $);
        this.updateAuthorisationOptions(model.get('data.authorisationOptions'), el, $);
        this.updateMirrorTrackingMode(model.get('data.mirrorTrackingMode'), el, $);
        this.updateRepositoryAccess(model.get('data.repositoryAccess'), el, $);

        Util.trackFieldChanges($('.max-runners-count'), $, function(val) {
            model.set('data.schedulerOptions.maxRunnersCount', parseInt(val, 10), this);
        });
        Util.trackFieldChanges($('.git-backend'), $, function(val) {
            model.set('data.repositoryAccess', val, this);
        });
        Util.trackFieldChanges($('#use-long-poll'), $, function(val) {
            model.set('data.longPollOptions.enabled', val, this);
        });
        Util.trackFieldChanges($('#track-active-mirrors'), $, function(val) {
            model.set('data.mirrorTrackingMode', val ? 'TRACK_ACTIVE' : 'TRACK_ALL', this);
        });
        Util.trackFieldChanges($('#long-poll-interval'), $, function(val) {
            model.set('data.longPollOptions.interval', parseInt(val, 10), this);
        });
        Util.trackFieldChanges($('#debug-log-level'), $, function(val) {
            model.set('data.logLevel', val ? 'INFO' : 'WARN', this);
        });

        Util.trackFieldChanges($('#use-role-based-authorisation'), $, function(val) {
            model.set('data.authorisationOptions.adminAuthorisationEnabled', val, this);
        });
        Util.trackFieldChanges($('#use-group-based-authorisation'), $, function(val) {
            model.set('data.authorisationOptions.groupAuthorisationEnabled', val, this);
        });
        Util.trackFieldChanges($('#mirror-group-name'), $, function(val) {
            model.set('data.authorisationOptions.mirrorGroupName', val, this);
        });
        Util.trackFieldChanges($('#import-group-name'), $, function(val) {
            model.set('data.authorisationOptions.importGroupName', val, this);
        });
    };

    GlobalSettings.prototype.update = function(event, el, $) {
        var self = this;
        event.changed('data.schedulerOptions.maxRunnersCount', function(previous, current) {
            self.updateRunnersCount(current, el, $);
        });
        event.changed('data.repositoryAccess', function(previous, current) {
            self.updateRepositoryAccess(current, el, $);
        });
        event.changed('data.mirrorTrackingMode', function(previous, current) {
            self.updateMirrorTrackingMode(current, el, $);
        });
        event.changed('data.longPollOptions', function(previous, current) {
            self.updateLongPollOptions(current, el, $);
        });
        event.changed('data.authorisationOptions', function(previous, current) {
            self.updateAuthorisationOptions(current, el, $);
        });
        event.changed('data.logLevel', function(previous, current) {
            self.updateDebugLevelOption(current, el, $);
        });
    };

    GlobalSettings.prototype.updateDebugLevelOption = function(level, el, $) {
        $('#debug-log-level').prop('checked', level === 'INFO');
    };

    GlobalSettings.prototype.updateAuthorisationOptions = function(options, el, $) {
        $('#use-role-based-authorisation').prop('checked', options.adminAuthorisationEnabled);
        $('#use-group-based-authorisation').prop('checked', options.groupAuthorisationEnabled);
        $('#mirror-group-name').val(options.mirrorGroupName);
        $('#import-group-name').val(options.importGroupName);
        $('#mirror-group-name').prop('disabled', !options.groupAuthorisationEnabled);
        $('#import-group-name').prop('disabled', !options.groupAuthorisationEnabled);
    };

    GlobalSettings.prototype.updateLongPollOptions = function(options, el, $) {
        $('#use-long-poll').prop('checked', options.enabled);
        $('#long-poll-interval').val(!isNaN(options.interval) ? options.interval : '');
        $('#long-poll-interval').prop('disabled', !options.enabled);
    };

    GlobalSettings.prototype.updateMirrorTrackingMode = function(options, el, $) {
        $('#track-active-mirrors').prop('checked', options === 'TRACK_ACTIVE');
    };

    GlobalSettings.prototype.updateRunnersCount = function(count, el, $) {
        $('.max-runners-count').val(count);
    };

    GlobalSettings.prototype.updateRepositoryAccess = function(type, el, $) {
        $('.git-backend').val(type);
    };

    return GlobalSettings;
});
