define('tmatesoft/svn/views/settings/config-editor', [
    'tmatesoft/svn/views/util'
], function(
    Util
) {
    'use strict';

    function ConfigEditor() {
        this.dataPath = 'data.config';
    };

    ConfigEditor.prototype.render = function(model, el, $) {
        var html = '';
        html += tmatesoft.svn.settings.configEditor();
        el.innerHTML = html;
    };

    ConfigEditor.prototype.setup = function(model, el, $) {
        var text = model.get(this.dataPath);
        $('textarea').val(text);

        var dataPath = this.dataPath;
        Util.trackFieldChanges($('textarea'), $, function(val) {
            val = Util.sanitizeText(val);
            model.set(dataPath, val, this);
        });
    };

    ConfigEditor.prototype.update = function(event, el, $) {
        event.changed(this.dataPath, function(previous, current) {
            $('textarea').val(current);
        });
    };

    return ConfigEditor;
});