define('tmatesoft/svn/views/settings/authors-mapping-settings', [
    '@atlassian/aui',
    'bitbucket/util/navbuilder',
    'tmatesoft/svn/views/util'
], function(
    AJS,
    nav,
    Util
) {

    'use strict';

    function AuthorsMappingSettings() {
    };

    AuthorsMappingSettings.prototype.render = function(model, el, $) {
        var globalAuthorsUrl = nav.pluginServlets().path('svn').build() + '#authors';
        var html = '';
        html += tmatesoft.svn.settings.authorsOptions({ stage : model.get('data.stage'), globalAuthorsUrl : globalAuthorsUrl });
        el.innerHTML = html;
    };

    AuthorsMappingSettings.prototype.setup = function(model, el, $) {
        Util.trackFieldChanges($('#defaultDomain'), $, function(val) {
            model.set('data.defaultDomain', val, this);
        });
        Util.trackFieldChanges($('#useLocalAuthorsMapping'), $, function(val) {
            model.set('data.authorsMapping.useLocal', val, this);
        });
        Util.trackFieldChanges($('#useStashAuthorsMapping'), $, function(val) {
            model.set('data.authorsMapping.useStash', val, this);
        });
        Util.trackFieldChanges($('#useGlobalAuthorsMapping'), $, function(val) {
            model.set('data.authorsMapping.useGlobal', val, this);
        });
        Util.trackFieldChanges($('#generateAuthorsMapping'), $, function(val) {
            model.set('data.generateAuthorsMappingOnConfigure', val, this);
        });

        $('<span class="domainHint"></span>').insertAfter('#defaultDomain');

        $('.local-authors-mapping-link').click(function(e) {
            e.preventDefault();
            AJS.tabs.change($.$('a[href="#authors-editor-tab"]'));
            return false;
        });

        this.updateCheckboxes(model, $);
        this.updateDomainField(model.get('data.defaultDomain'), $);
        this.updateHint(model.get('data.defaultDomain'), $);
    };

    AuthorsMappingSettings.prototype.update = function(event, el, $) {
        var self = this;
        event.changed('data.authorsMapping', function(previous, current) {
            self.updateCheckboxes(event, $);
        });
        event.changed('data.layoutType', function(previous, current) {
            self.updateCheckboxes(event, $);
        });
        event.changed('data.generateAuthorsMappingOnConfigure', function(previous, current) {
            self.updateCheckboxes(event, $);
        });
        event.changed('data.defaultDomain', function(previous, current) {
            self.updateDomainField(current, $);
            self.updateHint(current, $);
        });
    };

    AuthorsMappingSettings.prototype.updateCheckboxes = function(model, $) {
        if (model.get('data.authorsMapping') !== null) {
            var mapping = model.get('data.authorsMapping');

            $('#useLocalAuthorsMapping').prop('checked', mapping.useLocal);
            $('#useStashAuthorsMapping').prop('checked', mapping.useStash);
            $('#useGlobalAuthorsMapping').prop('checked', mapping.useGlobal);
        }

        $('#generateAuthorsMapping').prop('disabled', model.get('data.layoutType') === 'AUTO');
        $('#generateAuthorsMapping').prop('checked', model.get('data.layoutType') === 'AUTO'
            || model.get('data.generateAuthorsMappingOnConfigure') === true);
    };

    AuthorsMappingSettings.prototype.updateDomainField = function(domain, $) {
        $('#defaultDomain').val(domain);
    };

    AuthorsMappingSettings.prototype.updateHint = function(domain, $) {
        $('.domainHint').text('svnUser = svnUser <svnUser@' + domain + '>');
    };

    return AuthorsMappingSettings;
});