define('tmatesoft/svn/views/settings/authors-editor', [
    'tmatesoft/svn/views/util'
], function(
    Util
) {
    'use strict';

    function AuthorsEditor() {
        this.dataPath = 'data.authors';
    };

    AuthorsEditor.prototype.render = function(model, el, $) {
        var html = '';
        html += tmatesoft.svn.settings.authorsEditor({ stage : model.get('data.stage' )});
        el.innerHTML = html;
    };

    AuthorsEditor.prototype.setup = function(model, el, $) {

        var dataPath = this.dataPath;
        Util.trackFieldChanges($('textarea'), $, function(val) {
            val = Util.sanitizeText(val);
            model.set(dataPath, val, this);
        });
        Util.trackFieldChanges($('#useLocalAuthorsMapping2'), $, function(val) {
            model.set('data.authorsMapping.useLocal', val, this);
        });

        var text = model.get(this.dataPath);
        var useLocal = model.get('data.authorsMapping.useLocal');
        $('textarea').val(text);
        if (model.get('data.stage') !== 'GLOBAL') {
            $('#useLocalAuthorsMapping2').prop('checked', useLocal);
            $('textarea').prop('disabled', !useLocal);
        }
    };

    AuthorsEditor.prototype.update = function(event, el, $) {
        event.changed(this.dataPath, function(previous, current) {
            $('textarea').val(current);
        });
        if (event.get('data.stage') !== 'GLOBAL') {
            event.changed('data.authorsMapping.useLocal', function(previous, current) {
                $('#useLocalAuthorsMapping2').prop('checked', current);
                $('textarea').prop('disabled', !current);
            });
        }

    };

    return AuthorsEditor;
});