define('tmatesoft/svn/views/root', [
    'tmatesoft/svn/views/command-view',
    'tmatesoft/svn/views/status-view',
    'tmatesoft/svn/views/tabs-view'
], function(
    CommandView,
    StatusView,
    TabsView
) {

    'use strict';

    function RootView(commandTracker) {
        this.commandTracker = commandTracker;
    };

    RootView.prototype.children = function() {
        var commandTracker = this.commandTracker;
        return {
            '.tabs-view' : function(model, el, $) {
                return new TabsView(commandTracker);
            },
            '.command-area' : function(model, el, $) {
                return new CommandView(commandTracker);
            },
            '.status-view' : function(model, el, $) {
                return new StatusView(commandTracker);
            }
        };
    };

    RootView.prototype.render = function(model, el, $) {
        var stage = model.get('data.stage');

        var html = '';
        html += '<div class="command-area"></div>';
        if (!stage || stage === 'LOG') {
            html += '<div class="retrieving-message">';
            html += '<h2 class="retrieving-message-header">Retrieving mirror data from Bitbucket Server</h2>';
            html += '</div>';
        }
        html += '<div class="tabs-view"></div>';
        el.innerHTML = html;
    };

    RootView.prototype.update = function(event, el, $) {
        var stage = event.get('data.stage');
        if (stage === 'LOG') {
            var message = event.get('data.message');
            $('<p>' + message + '</p>').insertAfter('.retrieving-message :last-child');
            return false;
        }
        if (event.isRemote) {
            var self = this;
            event.changed('data.longPollOptions', function(previous, current) {
                if (previous && current) {
                    self.commandTracker.updatePollOptions(current);
                }
            });
        }
        if (event.changed('data.stage') || event.changed('task') || event.changed('pending')) {
            this.updateStatusVisibility(event, el, $);
        }
        return false;
    };

    RootView.prototype.updateStatusVisibility = function(event, el, $) {
        var stage = event.get('data.stage');

        if (stage) {
            $('.retrieving-message').remove();
        }

        var showStatus = false;
        var showTabs = true;
        if (!stage || stage === 'NO_LICENSE' || stage == 'INCOMPATIBLE') {
            showStatus = false;
        } else if (stage === 'CONFIGURED' || stage == 'INITIAL') {
            var runningTask = event.get('task');
            var pending = event.get('pending') || [];
            showStatus = (runningTask && runningTask.state === 'RUNNING') || pending.length > 0;
        } else if (stage === 'GLOBAL' || stage === 'PROJECT') {
            var runningTask = event.get('task');
            showStatus = (runningTask
                && runningTask.name === 'bootstrap'
                && (runningTask.state === 'PENDING' || runningTask.state === 'RUNNING'));
            showTabs = !showStatus;
        } else {
            showStatus = true;
        }

        if (showStatus) {
            if ($('.status-view').length === 0) {
                $(el).prepend('<div class="status-view"></div>');
            }
        } else {
            $('.status-view').remove();
        }
        if (showTabs) {
            if ($('.tabs-view').length === 0) {
                $(el).append('<div class="tabs-view"></div>');
            }
        } else {
            $('.tabs-view').remove();
        }
    };

    return RootView;
});