define('tmatesoft/svn/views/repository-table', [
    'tmatesoft/svn/views/list-view',
    'tmatesoft/svn/views/repository-item-provider',
    'tmatesoft/svn/views/repository-item'
], function(
    ListView,
    RepositoryItemProvider,
    RepositoryItem
) {

    'use strict';

    function RepositoryTable(commandTracker) {
        this.commandTracker = commandTracker;
    };

    RepositoryTable.prototype.children = function() {
        var commandTracker = this.commandTracker;
        return {
            'tbody' : function(model, el, $) {
                var pageScope = model.get('scope');
                var listViewOptions = {
                    itemProvider : new RepositoryItemProvider(),
                    tagName : 'tr',
                    attrName : 'data-scope',
                    itemViewFactory : function(model, el, $) {
                        var scopeId = el.getAttribute('data-scope');
                        var item = model.get('children.' + scopeId);
                        return new RepositoryItem(item, pageScope, commandTracker);
                    }
                };
                return new ListView(listViewOptions);
            }
        };
    };

    RepositoryTable.prototype.render = function(model, el, $) {
        el.innerHTML = tmatesoft.svn.repositoryTable({
          mirrorTrackingMode: model.get('data.mirrorTrackingMode')
        });
    };

    RepositoryTable.prototype.setup = function(model, el, $) {
        var self = this;
        $('#reload,#empty-reload').click(function() {
            var commandName = $(this).attr('data-command');
            self.commandTracker.sendCommand(commandName, model.get());
        });
        this.commandListener = this.commandTracker.on('sent submitted completed cancelled',
            function(eventName) {
                $('#reload').prop('disabled', eventName === 'sent' || eventName === 'cancelled');
            });
        this.updateTableVisibility(this.getChildCount(model.get('children')), $);
    };

    RepositoryTable.prototype.update = function(event, el, $) {
        if (event.changed('children')) {
            this.updateTableVisibility(this.getChildCount(event.get('children')), $);
        } else if (event.changed('data.mirrorTrackingMode')) {
            return true;
        }
    };

    RepositoryTable.prototype.updateTableVisibility = function(childCount, $) {
        $('.empty-view').toggle(childCount === 0);
        $('.repository-table').toggle(childCount !== 0);
    };

    RepositoryTable.prototype.getChildCount = function(children) {
        var count = 0;
        if (!children) {
            return count;
        }
        for(var key in children) {
            if (children.hasOwnProperty(key)) {
                count++;
            }
        }
        return count;
    };

    return RepositoryTable;
});